/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TableCellLabelProvider.java,v 1.2 2008/03/10 19:20:21 ewchan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.tptp.platform.tablecelllabelprovider.sample;

import org.eclipse.hyades.ui.provisional.context.IContextAttributes;

public class TableCellLabelProvider extends
		org.eclipse.tptp.platform.common.ui.views.TableCellLabelProvider {

	/**
	 * Tooltips content is returned by this method.
	 */
	public String getColumnHoverText(Object element, String columnID) {
		return "Sample Tooltips>> "+element+"\n Column>> "+columnID;
	}

	/**
	 * Return the column IDs that are supported by this provider sample.
	 */
	public String[] getSupportColumnKeys() {
		return new String[] {
				IContextAttributes.PACKAGE_ACTIVE_SIZE,
				IContextAttributes.PACKAGE_AVG_BASE_TIME,
				IContextAttributes.PACKAGE_BASE_TIME,
				IContextAttributes.PACKAGE_INH_BASE_TIME,
				IContextAttributes.PACKAGE_CUMULATIVE_TIME,
				IContextAttributes.PACKAGE_INH_CUMULATIVE_TIME,
				IContextAttributes.PACKAGE_CPU_TIME,
				IContextAttributes.PACKAGE_CALLS,
				IContextAttributes.PACKAGE_INH_CALLS,
				IContextAttributes.PACKAGE_TOTAL_INST,
				IContextAttributes.PACKAGE_LIVE_INST,
				IContextAttributes.PACKAGE_COLLECTED_INST,
				IContextAttributes.PACKAGE_TOTAL_SIZE,
				IContextAttributes.PACKAGE_ACTIVE_SIZE,
				};
	}

}
