/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RecordList.java,v 1.2 2008/01/24 02:29:24 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logc.correlators;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

/**
 * RecordList is a wrapper for an EList which containes records of a specific log.
 * Since the filtering and correlation schemas may be log type dependent, the logType
 * needs to be set to the name/type of the log.
 */
public class RecordList extends BasicEList {

    /**
	 * 
	 */
	protected static final long serialVersionUID = 3258407318340514102L;
	protected String logType;

    public RecordList(EList list, String type){
    	
    	addAll(list);
    	logType = type;
    }
    
    public EList getList(){
    	
       return this;	
    }
    
    public String getLogType(){
    	
       return logType;	
    }


}
