/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IConnectUtilUI.java,v 1.2 2006/11/07 00:31:11 samwai Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.security.internal.util;

import java.security.KeyStore;
import java.security.cert.X509Certificate;

import org.eclipse.core.runtime.IStatus;

public interface IConnectUtilUI {

	public abstract int openQuestionDialog(final String title,
			final String msg, final String[] btnLabels);

	public abstract void openCertificateDetailDialog(
			final X509Certificate certificate);

	public abstract boolean openSaveCertificateDialog(final KeyStore ks);

	public abstract void openErrorDialog(String title, String message,
			IStatus err);

	public abstract String getAlias();

	public abstract IConnectUtilUser promptAuthentication(String hostName, String userName);
}