/**********************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.security.internal.util;

/**
 * This interface describes an implementation of a secure storage provider for
 * connecting to a secure TPTP Agent Controller.  An implementation of this 
 * interface will attempt to provide a username and password for connecting
 * to a specified host by querying some secure storage facility.
 * 
 * @author jtoomey
 *
 */
public interface ITPTPSecureStorageProvider {

	/**
	 * This method will attempt to provide a username and password for 
	 * connecting to the specified hostname by querying some secure storage 
	 * facility.  If credentials are successfully located, they will be 
	 * returned in the userName and password StringBuffers and the method
	 * will return true.  The method will return false otherwise.
	 * 
	 * @param hostname
	 * @param userName
	 * @param password
	 * @return true if the a username and password were located for the 
	 * specified host.  false otherwise.
	 */
	public boolean getCredentialsForHost(String hostname, StringBuffer userName, StringBuffer password);
	
}
