/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PrintStreamLogger.java,v 1.2 2008/01/24 02:29:24 apnan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.util;

import java.io.PrintStream;

import org.eclipse.hyades.ui.util.ILogger;
import org.eclipse.tptp.platform.common.internal.util.CoreUtil;


/**
 * Implementation of {@link org.eclipse.hyades.ui.util.ILogger} that logs the
 * data to specifics output and error {@link java.io.PrintStream print streams}. 
 * 
 * @author marcelop
 * @since 0.0.1 
 */
public class PrintStreamLogger 
implements ILogger
{
	/**
	 * Instance of PrinterStreamLogger that used the SYSTEM default output and error
	 * print streams.
	 */
	public static final ILogger SYSTEM = new PrintStreamLogger(System.out, System.err);
	
	protected PrintStream out;
	protected PrintStream err;
	
	/**
	 * Constructor for ConsoleLogger
	 * @param out The output print stream
	 * @param err The error print stream
	 */
	public PrintStreamLogger(PrintStream out, PrintStream err)
	{
		this.out = out;
		this.err = err;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		out = null;
		err = null;
	}

	/**
	 * @see org.eclipse.hyades.ui.util.ILogger#logError(java.lang.String)
	 */
	public void logError(String text)
	{
		err.println(text);
	}

	/**
	 * @see org.eclipse.hyades.ui.util.ILogger#logError(java.lang.Throwable)
	 */
	public void logError(Throwable throwable)
	{
		err.println(CoreUtil.getStackTrace(throwable));
	}

	/**
	 * @see org.eclipse.hyades.ui.util.ILogger#logInfo(java.lang.String)
	 */
	public void logInfo(String text)
	{
		out.println(text);
	}
}
