/**********************************************************************
 * Copyright (c) 2006, 2010 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonPlugin.java,v 1.11 2010/02/24 15:39:22 paules Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.common.internal;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.ui.util.ILogger;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 * 
 * 
 * @author     Paul Slauenwhite
 * @version    February 24, 2010
 * @since      August 15, 2006
 */
public class CommonPlugin extends Plugin {
	
	protected final static String KEYSTORE = "keystore.dat";

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.tptp.platform.common";

	// The shared instance
	protected static CommonPlugin plugin;
	
	protected ILogger logger;
	
	/**
	 * The constructor
	 */
	public CommonPlugin() {
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		/*
			Bug 287604: Remove Agent Controller configuration from plug-in startup. 
			if(AdminUtil.isNeedToGenerateConfigFile(true)){
				AdminUtil.generateConfigFile(true);
			}
		*/	
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin = null;
		logger = null;
		super.stop(context);
	}

	/**
	 * Logs an informational text message to the plug-in's log.
	 * 
	 * @param message The logged informational text message.
	 */
	public static void logInfo(String message) {
		log(new Status(IStatus.INFO, PLUGIN_ID, message));
	}
	
	/**
	 * Logs an error text message to the plug-in's log.
	 * 
	 * @param message The logged error text message.
	 */
	public static void logError(String message){
		log(new Status(IStatus.ERROR, PLUGIN_ID, message));
	}

	/**
	 * Logs a {@link Throwable} to the plug-in's log.
	 * 
	 * @param throwable The logged {@link Throwable}.
	 */
	public static void logError(Throwable throwable){
		log(new Status(IStatus.ERROR, PLUGIN_ID, throwable.toString(), throwable));
	}

	/**
	 * Logs a {@link IStatus} to the plug-in's log.
	 * 
	 * @param status The logged {@link IStatus}.
	 * @deprecated As of TPTP 4.7.0, use {@link #log(IStatus)}.
	 */
	public static void logError(IStatus status){
		log(status);
	}
	
	/**
	 * Logs a {@link IStatus} to the plug-in's log.
	 * 
	 * @param status The logged {@link IStatus}.
	 */
	public static void log(IStatus status){
		getDefault().getLog().log(status);
	}
		
	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static CommonPlugin getDefault() {
		return plugin;
	}
	
	/**
	 * Returns the an instance of {@link ILogger} that used the
	 * <code>log</code> methods of this class.
	 * @return ILogger
	 */
	public static ILogger getLogger()
	{
		if(plugin.logger == null)
		{
			plugin.logger = new ILogger()
			{
				public void logError(Throwable throwable)
				{
					logError(throwable);
				}

				public void logError(String text)
				{
					logError(text);
				}

				public void logInfo(String text)
				{
					logInfo(text);
				}
			};
		}
		return plugin.logger;
	}
    	
	public static IWorkspaceRoot getRoot()
	{
		return ResourcesPlugin.getWorkspace().getRoot();
	}
	public static String getKeyStoreLocation() {
		
		return Platform.getPluginStateLocation(plugin).append(KEYSTORE).toOSString();
	}
	
}
