/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CoreUtil.java,v 1.3 2006/09/05 22:22:07 ewchan Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.common.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/**
 * Contains UI utility methods. 
 * For non-ui utility methods, see {@link org.eclipse.hyades.test.core.util.CoreUtil CoreUtil}
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class CoreUtil
{
	/**
	 * Returns the throwable's stack trace as a String.
	 * @param throwable
	 * @return String
	 */
	public static String getStackTrace(Throwable throwable)
	{
		if(throwable == null)
			return null;
			
		ByteArrayOutputStream errorStream;		
		PrintStream errorPS;		

		errorStream = new ByteArrayOutputStream();
		errorPS = new PrintStream(errorStream);

		throwable.printStackTrace(errorPS);
		errorPS.flush();
		
		String stackTrace = errorStream.toString();
		
		try
		{
			errorStream.close();
		}
		catch(Exception e)
		{
		}
		
		return stackTrace;
	}
	
}