/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.common.provisional;

import org.eclipse.core.runtime.IStatus;

public class EclipseOperationStatus implements IOperationStatus {

	protected IStatus status;
	protected IOperationStatus[] children;
	
	public EclipseOperationStatus(IStatus status) {
		super();
		setStatus(status);
	}

	protected void setStatus(IStatus status){
		this.status = status;
		IStatus[] childIStatus = status.getChildren();
		children = new IOperationStatus[childIStatus.length];
		for (int x = 0; x < childIStatus.length; x++){
			children[x] = new EclipseOperationStatus(childIStatus[x]);			
		}
		
	}
	public IOperationStatus[] getChildren() {
		return children;
	}

	public Throwable getException() {
		return status.getException();
	}

	public String getMessage() {
		return status.getMessage();
	}

	public int getSeverity() {
		return status.getSeverity();
	}

	public boolean isMultiStatus() {
		return status.isMultiStatus();
	}

	public boolean isOK() {
		return status.isOK();
	}

	public boolean matches(int severityMask) {
		return status.matches(severityMask);
	}

	public IStatus getStatus() {
		return status;
	}

}
