/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * 
 * @author apnan
 * @provisional
 * @since TPTP4.2
 *  
 */

package org.eclipse.tptp.platform.common.provisional;


/**
 * 
 * Defines a generic context in which a log analyzer operation is executed.
 * The intention of this interface is to adapt objects required by log analyzer operations. For example it could adapt
 * an IOperationMonitor neccessary to monitor progress activity on an import/export symptom database operation.
 * In an import symptom catalog operation it could also provide information about the model that will be instantiated to persist the imported symptom database.  
 * 
 */

public interface IOperationContext {
	
	/** 
	* Returns an object which is an instance of the given class associated with this object. Returns <code>null</code> if
	* no such object can be found. *
	* 
	* @param adapter The adapter class to look up
	* @return an object castable to the given class, 
	* or <code>null</code> if this object does not
	* have an adapter for the given class.
	*/
	public Object getProperty(String id);

	/**
	* Associates an id to an object. The id specifies a specific property name required by the task the context is associated with.
	* @param id property id name
	* @param value property value
	* 
	*/ 
	public void setProperty(String id, Object value); 


	
	/**
	 *  
	 * @return The status of the operaion.
	 */
	public IOperationStatus getStatus();
	
	/**
	 * Sets the current status of the operation.
	 * @param status
	 */
	public void setStatus(IOperationStatus status);

}
