/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OperationContextImpl.java,v 1.3 2006/09/05 16:50:49 sleeloy Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.common.provisional;

import java.util.HashMap;
import java.util.Map;

public class OperationContextImpl implements IOperationContext {

	protected IOperationStatus status;
	protected Map properties = new HashMap();
	
	public OperationContextImpl() {
		super();
		status = new OperationStatusImpl();
		((OperationStatusImpl)status).setSeverity(IOperationStatus.OK);
		((OperationStatusImpl)status).setMessage("org.eclipse.tptp.platform.common.provisional");
	}

	public Object getProperty(String id) {
		return properties.get(id);
	}

	public IOperationStatus getStatus() {
		// TODO Auto-generated method stub
		return status;
	}

	public void setProperty(String id, Object value) {
		properties.put(id, value);

	}

	public void setStatus(IOperationStatus status) {
		this.status = status;
	}

}
