/**********************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OperationStatusImpl.java,v 1.1 2006/09/05 16:50:49 sleeloy Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
 package org.eclipse.tptp.platform.common.provisional;

public class OperationStatusImpl implements IOperationStatus {

	protected Throwable exception;
	protected String message;
	protected int severity;
	protected IOperationStatus[] children;
	
	public Throwable getException() {
		return exception;
	}


	public String getMessage() {
		return message;
	}


	public IOperationStatus[] getChildren() {
		return children;
	}


	public void setChildren(IOperationStatus[] children) {
		this.children = children;
	}


	public void setException(Throwable exception) {
		this.exception = exception;
	}


	public void setMessage(String message) {
		this.message = message;
	}


	public void setSeverity(int severity) {
		this.severity = severity;
	}


	public int getSeverity() {
		return severity;
	}


	public boolean isMultiStatus() {
		return ((children != null) && (children.length>0));
	}

	public boolean isOK() {
		return (severity == OK);
	}

	public boolean matches(int severityMask) {
		return (severity & severityMask) != 0;
	}

}
