/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SWTGraphicViewer.java,v 1.6 2008/05/23 14:12:20 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/*
 * Created on Mar 10, 2005
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.tptp.platform.report.core.provisional;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.provisional.IChart;
import org.eclipse.tptp.platform.report.core.provisional.IRenderer;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTViewer;

/**
 * Concrete class that provides an eclipse viewer to view charts.
 * When embedding a SWT chart inside an existing Eclipse view part, the SWTGraphicViewer
 * class takes in a parent component. You can provide a ViewPart extension and embed an 
 * SWT chart within the view.
 * <p>
 * To create a chart and render the chart in SWT, create an XML input file or a XML DOM that 
 * represents the chart you want to render. The XML file should contain the raw 
 * data and configuration data needed by the chart service to create the chart. 
 * The following is a fragment of code that will allow you to generate the chart.
 * <pre> 
 * 
 *     1 FileInputStream inputStream = new FileInputStream(new File("chart.xml")); 
 *     2 IChart chart = SerializerImpl.instance().read(inputStream); 
 *     3 IRenderer renderer = new SWTRenderer(parent, SWT.DIALOG_TRIM|SWT.RESIZE );
 *     4 Generator.instance().run(renderer, chart);   
 *     
 * Line 1 - In this line an input stream from an XML file is created. The XML file 
 *          is formatted based on the input schema and contains the raw data and 
 *          configuration data for the chart.
 * 
 * Line 2 - The SerializerImpl class provides a read method that will allow one to 
 *          take the XML stream and construct an internal representation of the chart 
 *          object model. It should be noted that the serializer interface can also 
 *          consume a XML document object model instead of an input stream. Therefore, 
 *          a developer can construct the XML document object model in memory and 
 *          pass in this DOM to the serializer. 
 * 
 * Line 3 - Construct a SWT renderer. The SWT renderer takes a parent SWT widget and 
 *          a set of SWT flags used to embed an SWT chart into the parent widget.
 * 
 * Line 4 - This line generates and writes the chart to the parent SWT widget, based 
 *          on the chart model which was parsed in Line 2.
 *</pre>
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class SWTGraphicViewer extends SWTViewer implements IRenderer {

	/**
	 * Construct a SWT renderer
	 * 
	 * @param parent Parent SWT widget.  
	 * @param style SWT component flags to configure the swt shell for the viewer.
	 */
	public SWTGraphicViewer(Composite parent, int style) {
		super(parent, style);
	}

	public void render(IChart chart) {
		if (chart instanceof IDItem) {
            setContent((IDItem)chart);
        }
            
	    /* This part of code is useless because the model translation is automatically
         * done by the SWT Viewer
         * 
	     *chart = (IChart)((DDocument)chart).getChildOfClass(DGraphic.class);

		// Convert chart object to DGraphic object
		/*if (chart instanceof DGraphic) {
	        DChartTranslator tc = new DChartTranslator();
	        DGraphic renderable = tc.translate((DGraphic)chart);
			setContent(renderable);
		}*/
        
        
		
	}
	/**
	 * This method provides the ability to set renderer specific parameters.  Currently
	 * this renderer does not support any properties.
	 * 
	 * @param key
	 *            The parameter name.
	 * @param value
	 *            The value of the parameter.
	 * @throws RendererException
	 *             Throws an exception if the parameter is not supported by
	 *             the renderer.
	 */	
	public void setProperty(String key, Object value) throws RendererException{
		throw new RendererException("Property key: " +key +" not supported by this renderer.");
	}

	protected void setContent(IDObject chartItem) {
	    if (chartItem instanceof IDItem)
		   super.setContent((IDItem)chartItem);
        else
            System.err.println("Unable to view an object of class "+ chartItem.toString());
	}

}
