/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TPageSplitter.java,v 1.3 2008/05/23 14:12:19 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.printer.internal;


import java.util.LinkedList;

import org.eclipse.swt.graphics.Point;
import org.eclipse.tptp.platform.report.core.internal.*;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ILayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.IMarginLayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCellContainer;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellParagraph;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellText;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;




/**
 * @author emiravet
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class TPageSplitter  {

   
   public class Page {

   	    //public LinkedList cells = new LinkedList();
   	    public int        y;
   	    public int        x;
   	    public int        w;
   	    public int        h;
   	    
   	    public TCellParagraph header;
   	    public TCellParagraph footer;
   }
   
   
   LinkedList pages = new LinkedList();
   int pageWidth;
   int pageHeight;
   
   
   public TPageSplitter()
   {
   	  pageWidth = ILayout.NO_SIZE_HINT;
   	  pageHeight = ILayout.NO_SIZE_HINT;
   }
	  
   
   class EndPageInfo
   {
   	  int      ymax;
   	  int      ymin = Integer.MAX_VALUE;
   	  TAbstractCell   start;
   	  DSection section;
   	  boolean  empty;
   }
   
   void pagesChildren(TAbstractCell cell, TAbstractCell start, int ypos, int h, int nupage, EndPageInfo info)
   {
   	  info.empty=true;
   	  for (TAbstractCell c=((start.getParent()==cell)? start : cell.getChild()); 
   	       c!=null; c=c.getNext())
   	  {
   	  	if ((c.getY()+c.getHeight())<ypos) continue;
   	  	if (c.getY()>ypos + h) continue;
   	  	
   	  	
   	  	if ((c.getItem() instanceof DSection)&&(info.section!=c.getItem()))
		{
   	  		info.section = (DSection)c.getItem();
   	  		info.start = c.getNext();
   	  		info.ymax = c.getY();
   	  		info.ymin = c.getY();
   	  		return;
   	  	}
   	  	  	
   	  	if (c.getChild()!=null)
   	  	{
   	  		int oldy = info.ymax;
   	  		int oldymin = info.ymin;
   	  		
   	  		int yp=0;
   	  		int nh=0;
   	  		if (ypos>=c.getY())
   	  		{
   	  			yp = ypos - c.getY();
   	  			nh = h;
   	  		}
   	  		else
   	  		{
   	  			yp = 0;
   	  			nh = (ypos+h) - c.getY();
   	  		}
   	  	    info.ymin = nh;
   	  	    info.ymax = 0;
   	  		
   	  		pagesChildren(c, c.getChild(), yp, nh, nupage, info);
   	  		info.ymax = Math.max(info.ymax + c.getY(), oldy);
   	  		info.ymin = Math.min(info.ymin + c.getY(), oldymin);
   	  	}
   	  	else
   	  	{	
   	  	
   	  	   // add the item to the page
   	  	   if (c.getY()+c.getHeight()<ypos + h)
   	  	   {
   	  		  info.ymax = Math.max(c.getY()+c.getHeight(), info.ymax);
   	  		  info.empty = false;
   	  	   }
   	       else
   	       {
   	          info.start = (info.start==null)? c: info.start;
   	       	  if (c instanceof TCellText)
   	       	  {
   	             info.ymin = c.getY();
   	       	  }
   	       	  else
   	       	  {
   	       	  	 info.ymin = (ypos + h);
   	       	  }
   	          return;
   	       }
   	  	
   	  	   if (c.getItem() instanceof DPageCounter)
   	  	   {
   	  		   ((TCellText)c).setText(String.valueOf(nupage));
   	  	   }
   	  	   else
   	  	   if (c.getItem() instanceof DPageBreak)
   	  	   {
   	  		   info.start = c.getNext();
   	  		   info.ymax = c.getY();
   	  		   return;
   	  	   }
   	  	} 	
   	  }
   	 
   	  if (info.start==null)
   	      info.ymax = Math.min(cell.getHeight()-ypos, h);
   }
   
   public void clear()
   {
   	  for (int i=0;i<getPageCount();i++)
   	  {
   	  	Page p = getPageAt(i);
   	  	p.footer.dispose();
   	  	p.header.dispose();
   	  }
   	  pages.clear();
   }
   
   
   public void split(TAbstractCellContainer /*MLayoutContentCellContainer*/ cell,  float zoom, IGC gc, 
                     IDIImageProvider pm, IDProgressMonitor monitor,
   		             DTitleLevel tl, DListLevel ll, boolean flatpopup, int char_pos)
   {
   	  clear();
   	  
   	  pageWidth = cell.getWidth();
   	  
   	  int ypos = 0;
   	  //int pageBody = pageHeight;
   	  EndPageInfo info = new EndPageInfo();
   	  DSection currentSection = null;
   	  DHeader header = null;
   	  DFooter footer = null;
   	  int     nupage = 1;
   	  
   	  int tm = 0, lm = 0, rm = 0, bm = 0;
   	  if (cell.getLayout() instanceof IMarginLayout)
   	  {
   	     tm = ((IMarginLayout)cell.getLayout()).getTopMargin();
   	     lm = ((IMarginLayout)cell.getLayout()).getLeftMargin();
   	     rm = ((IMarginLayout)cell.getLayout()).getRightMargin();
   	     bm = ((IMarginLayout)cell.getLayout()).getBottomMargin();
   	  }
   	  
   	  while (ypos < cell.getHeight())
   	  {
   	  	  Page currentPage = new Page();
   	  	
   	  	  //TAbstractCell footCell = null;
   	  	  int bodyHeight  = pageHeight;  
   	  	  
   	  	  if (header!=null)
   	  	  {
   	  	  	 //currentPage.header = new TCellContainer(header, new TCellParagraph(header.getAlignment()));
   	  	     currentPage.header = new TCellParagraph(header, null, header.getAlignment());
   	  	  	 currentPage.header.setMargin(lm, rm, tm, bm);
   	  	  	 currentPage.header.fillContent(header, gc, pm, monitor, tl, ll, flatpopup);
   	  	  	 currentPage.header.computeSize(pageWidth, ILayout.NO_SIZE_HINT, zoom, gc, monitor);
   	  	  	 char_pos = currentPage.header.layout(zoom, char_pos, monitor);
   	  	  	
   	  	  	 pagesChildren(currentPage.header, currentPage.header.getChild(), 0, pageHeight, nupage, info);
   	  	  	 bodyHeight -= currentPage.header.getHeight();
   	  	  }
          
   	  	  if (footer!=null)
   	  	  {
   	  	  	//currentPage.footer = new TCellContainer(footer, new TCellParagraph(footer.getAlignment()));
   	  	    currentPage.footer = new TCellParagraph(footer, null, footer.getAlignment());
   	  	  	currentPage.footer.setMargin(lm, rm, tm, bm);
   	  	  	currentPage.footer.fillContent(footer, gc, pm, monitor, tl, ll, flatpopup);
   	  	  	currentPage.footer.computeSize(pageWidth, ILayout.NO_SIZE_HINT, zoom, gc, monitor);
   	  	  	char_pos = currentPage.footer.layout(zoom, char_pos, monitor);
   	  	  		
   	  	  	bodyHeight -= currentPage.footer.getHeight();
   	  	  }
   	  	  
   	  	  TAbstractCell start = info.start;
   	  	  info.ymax     = 0;
   	  	  info.ymin     = Integer.MAX_VALUE;
   	  	  info.start = null;
   	  	  
   	      pagesChildren(cell, (start==null)?cell.getChild():start, ypos, bodyHeight, nupage, info);
   	      
   	      currentPage.y = ypos;
   	      currentPage.h = ypos + info.ymax;
   	      currentPage.w = pageWidth;
   	      currentPage.x = 0;
   	      ypos += info.ymin;
   	      
   	      if (currentPage.footer!=null)
   	      {	
   	      	 pagesChildren(currentPage.footer, currentPage.footer.getChild(), 
   	      			       0, pageHeight - currentPage.footer.getHeight() - bodyHeight, nupage, info);
   	      }
   	      
   	      if ((info.section!=null) && (info.section!=currentSection))
   	      {
   	      	header = info.section.getHeader();
   	      	footer = info.section.getFooter();
   	      	currentSection = info.section;
   	      }
   	      
   	      // adds the page if it is valid page
   	      if (!info.empty)
   	      {	
   	         pages.addLast(currentPage);
   	         nupage ++;
   	      }
   	  }	
   }
   
   public int getPageCount()
   {
   	  return pages.size();
   }
   
   public Page getPageAt(int i)
   {
   	  return (Page)pages.get(i);
   }
      
   public Page getLastPage()
   {
   	  return (Page)pages.getLast();
   }
   
   /**
    * @return Returns the h.
    */
   public void setPageSize(int w, int h) 
   {
   	   pageWidth = w;
   	   pageHeight = h;
   }

   /**
    * @param h The h to set.
    */
   public Point getPageSize() 
   {
   	   return new Point(pageWidth, pageHeight);
   }

}
