/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IContentProvider.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/*
 * Created on 8 nov. 2004
 *
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;


/**
 * This interface provides services to fill a cell container with an IDItem.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public interface IContentProvider {

    /** fills the cell container with a children cell for each child of the IDItem 
     * @param cell is the cell container for the IDItem item 
     * @param item is the JScrib IDItem mapped by the cell container 
     * @param gc is the graphic context used to render the cell container 
     * @param pm is the image provider to resolve image link 
     * @param titleLevel is the current title level in the document analyse
     * @param listLevel is the current list level in the document analyse
     * @param flatpopup sets the mode to insert DPopup item in the document
     * <br>
     * Ex: to fill a container:
     * <PRE>
     * myContainer.getContentProvider().fillContent(myContainer, myitem, mygc, mypm, 
     *                                              new DTitleLvel(), new DListLevel(), false);
     * </PRE>
     * <br>
     * The SWTViewer realizes this call automatically for its content
     * @see SWTViewer#setContent(IDItem)
     * @see SWTViewer#setContent(TAbstractCellContainer)
     * */ 
    public void fillContent(TAbstractCellContainer cell, IDItem item, IGC gc, IDIImageProvider pm,
                            IDProgressMonitor monitor,
    		                DTitleLevel titleLevel, DListLevel listLevel, boolean flatpopup);
    
}
