/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellFocusMark.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 6 janv. 2004
 *
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;


/**
 * This cell type is used by the builder to mark the cells that can receive
 * the keyboard focus. This cell appears before the first cell (next) and marks
 * the last cell of the focus zone
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class TCellFocusMark extends TAbstractCell {

	private TAbstractCell endMark;
   
	/**
	 * Create a null data TCellData.
	 */
	public TCellFocusMark(IDItem i) 
	{
		super(i);
	}
   
	/**
	* set the end cell to null, and call super.dispose().
	* @see IVObject#setObject()
	*/
    public void dispose()
	{
	   	 endMark = null;
		 super.dispose();
	}
   

	/**
	 * @return
	 */
	public TAbstractCell getEndMark() {
		return endMark;
	}

	/**
	 * @return
	 */
	public TAbstractCell getStartMark() {
		return getNext();
	}

	/**
	 * @param cell
	 */
	public void setEndMark(TAbstractCell cell) {
		endMark = cell;
	}
	
	/**
	 * @return true if the cell has the focus
	 */
	public boolean hasFocus(TAbstractCell cell)
	{
		if (endMark==null) return false;
		
		for (TAbstractCell c = getStartMark(); (c!=null)&&(c!=getEndMark().getNext()); c = c.getNext() )
		{
			if (cell == c) return true;
		}
		return false;
	}

	/**
	 * @return the text which is in the focus mark
	 */
	public String getLinkText()
	{
		String result = "";
		for (TAbstractCell c = getStartMark(); (c!=null)&&(c!=getEndMark().getNext()); c = c.getNext() )
		{
		    if (c instanceof TCellText)
		        result += ((TCellText)c).getText();
		}
		return result;
	}

	public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor)
	{}

    /**
     * @see org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell#dump(int)
     */
    public void dump(int level) 
    {}
}
