/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellImage.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 1 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDSizeableItem;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;




/**
 * Enter here your comment
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class TCellImage extends TAbstractCell 
{
	private IImage image = null;
	
	/**
	 * Returns always true
	 */
	public boolean isImage()
    {
		return true;
    }
	
	/**
	 * Builds a new TCellImage mapped on a DImage core item and sets directly the
	 * associated SWT Image. The image field will be not resolved by using the
	 * DImageProvider of the render object.
	 * 
	 * @see DImageProvider
	 */
	public TCellImage(DImage i, IImage aImage, int w, int h)
	{
		super (i);
		image = aImage;
		setSize(w, h);
	}
	
	/**
	 * Builds a new TCellImage mapped on any IDItem
	 */
	public TCellImage(IDItem i)
	{
		super(i);
	}
	
	/**
	 * Returns the SWT Image object (pixmap)
	 */
	public IImage getImage() 
	{
	   return image;    
	}
   
	/**
	 * Sets the SWT Image object (pixmap) and the size
	 */
	public void setImage(IImage aImage, int w, int h) 
	{
	   image = aImage;
	   setSize(w, h);
	}
	
	/**
	 * Computes the real size of the image by applying the zoom factor
	 */
	public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor)
	{	
	   int w, h;
	   if( getItem() instanceof IDSizeableItem )
	   {
	     IDSizeableItem i = (IDSizeableItem)getItem();
	     w = (int)(getImage().getWidth()  * i.getWidthScale() * zoom);
	     h = (int)(getImage().getHeight() * i.getHeightScale() * zoom);
	   } else {
	     w = (int)(getImage().getWidth()  * zoom );
	     h = (int)(getImage().getHeight() * zoom );
	   }
	   //DrawUtilIGC.convertDPISizeToDPISize(p, Display.getCurrent());
	   setSize(w, h);
	}

    public void dump(int level) 
    {
        for (int i=0; i<level; i = i + 1)
  		   System.out.print("  ");
  		   
  	    System.out.print("<cell x=\"" + getX() + "\" y=\"" + getY() 
  								+ "\" w=\"" + getWidth() + "\" h=\"" + getHeight()
  								+ "\"" );
  	
  		System.out.print(" type=\"image\">");	 
  		
  	    System.out.println("</cell>");   
    }
	
}
