/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellSymbol.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IGC;


/**
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class TCellSymbol extends TCellLinePrefix
{
  public TCellSymbol( IDItem item )
  {
    super( item );
  }
  
  public void computeSize(int hintW, int hintH, float zoom, IGC gc)
  {
    IDFont font = IGCDStyle.GetIDFont( getItem() );
    int size ;
    //as default printer font size in SWT is 1 pixel ... try a workaround 
    if( font == null )
    {      
      size = (int)Math.round( 10*zoom);
    } else {
      int fs = gc.getFontMetrics().getHeight();    
      size = (int)(fs*zoom)-4;
    }
    if( size<0 ) size+=4;
    setSize(size, size);
  }
}