/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellUtil.java,v 1.4 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/*
 * Created on 12 nov. 2004
 *
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.IDTaggedItem;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;


/**
 * @author emiravet
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TCellUtil {

    /** Returns the cell where the point p is contained */
    public static TAbstractCell MapPointToCell(TAbstractCell cell, IPoint p)
    {
      if (cell==null) return null;
      
      // check if the point is in the cell
 	  if (!cell.contains(p.getX(), p.getY())) return null;
 	     
 	  p.setX(p.getX() - cell.getX());
 	  p.setY(p.getY() - cell.getY());
 		   
 	  for (TAbstractCell i = cell.getChild(); i != null; i = i.getNext())
 	  { 	
 	     TAbstractCell cf = MapPointToCell(i, p);
 		 if (cf!=null) return cf;
 	  }
 	  
 	  return cell;
    }
    	
    
    /** returns the cell where the position pos is contained */
    public static TAbstractCell MapPositionToCell(TAbstractCell cell, int pos)
    {
 	 // if ((getPosition() <= pos) && (pos <= getPosition() + getLen())) 
 	 //    return this; 
      if (cell==null) return null;	
        
 	  for (TAbstractCell i = cell.getChild(); i != null; i = i.getNext())
 	  {
 		  TAbstractCell cf = MapPositionToCell(i, pos);
 		  if (cf!=null) return cf;
 	  }
 	  return null;
    }
    
    /** the closest cell with text on your left */
    public static final int LEFT_DIRECTION = 1;
    /** the closest cell with text on your right */
    public static final int RIGHT_DIRECTION = 2;
    
    /** Returns the closest text cell of the point p in the direction dir.
     * dir can have LEFT_DIRECTION or RIGHT_DIRECTION */
    public static TCellText MapPointToClosestTextCell(TAbstractCell cell, IPoint p, int dir)
    {
       if (cell==null) return null; 
        
 	   //TCell cf = this;     
 	   int x = p.getX() - cell.getX();
 	   int y = p.getY() - cell.getY();
 		   
 	   //int min_dist =Integer.MAX_VALUE;
 	   TCellText prev = null;
 	   for (TAbstractCell i = cell.getChild(); i != null; i = i.getNext())
 	   { 	
 		  TCellText cf = MapPointToClosestTextCell(i, p, dir);
 		  if (cf!=null) return cf;
 		  
 		  if (!(i instanceof TCellText)) continue;
 		  if (i.getY()+i.getHeight()<y) {prev=(TCellText)i;continue;}
 		 
// 		  
// 		  // compute distance between i and p
// 		  int d = (int)Math.sqrt((p.x-i.getX())*(p.x-i.getX())+(p.y-i.getY())*(p.y-i.getY()));
// 		  min_dist = Math.min(min_dist, d);
 		  
 		  if (dir == LEFT_DIRECTION)
 		  {
 		  	 if ((i.getX()+i.getWidth()<x) && (i.getY()<y)) {prev=(TCellText)i;continue;} 
 		  	 return prev; 
 		  }
 		  else
 		  {
 		  	 if (i.getX()>x) return (TCellText)i;
 		  }
 		  prev = (TCellText)i;
 	   }
 	   
 	   return null;
    }
    
    /**
     * Search a cell which is associated with a ITaggedItem and is named tag. 
     */
    /*public static TCell SearchCellNamed(String tag)
    {
    	  if (item!=null && (item instanceof IDTaggedItem))
    	  {
    	  	String t = ((IDTaggedItem)item).getTag();
    	  	if ((t!=null) && (t.equals(tag))) return this;
    	  }
    	  return null;
    }*/
    
    /**
	 * @param c
	 * @param pos
	 * @return 
	 */
	public static TAbstractCell SearchCellNamed(TAbstractCell cell, String tag) 
	{
        if (cell==null) return null;
        
	    if (cell.getItem()!=null && (cell.getItem() instanceof IDTaggedItem))
    	{
    	  	String t = ((IDTaggedItem)cell.getItem()).getTag();
    	  	if ((t!=null) && (t.equals(tag))) return cell;
    	}
	    
	    for (TAbstractCell i = cell.getChild(); i != null; i = i.getNext())
		{
			  TAbstractCell j = SearchCellNamed(i, tag);
			  if (j!=null) return j;
		}
	    
	    return null; 
	} 
    
    /** Returns the absolute XY cell's coordinates	*/
    public static void GetGlobalCellXY(TAbstractCell cell, IPoint p) 
    {
        if (cell==null) return;
        
    	 p.setX(cell.getX());
    	 p.setY(cell.getY());
    	 
    	 for (TAbstractCell c = cell.getParent(); c!=null; c=c.getParent())
    	 {
    	 	p.setX(p.getX() + c.getX());
    	 	p.setY(p.getY() + c.getY());
    	 }
    	     
    }
    
    /** Returns the text between position begpos and lastpos */ 
    public static String GetTextRange(TAbstractCell cell, int begpos, int lastpos) 
    {
    	String result = new String();
        
        if (cell==null) return null;
        
    	TAbstractCell i;
    	for (i = cell.getChild(); (i != null); i = i.getNext())
    	{
    		if (i.getChild()!=null)
    		{
    			String j = GetTextRange(i, begpos,lastpos);
    			if (j!=null) result = result + j;
    		}
    		
    		if (!(i instanceof TCellText)) continue;
    	    TCellText ct = (TCellText)i;
    		
    		String text = ct.getText();
    		if(text == null) continue;
    		
    	/*	if (i.getPosition()>lastpos) 
    			return result;
    		else
    		if (i.getPosition()+i.getLen()-1 < begpos)
    			continue;
    		else
    		if ((begpos <= i.getPosition() && (i.getPosition()+i.getLen()<=lastpos)))
    		    result += text.substring(i.getStart(), i.getStart()+i.getLen());
    		else
    		if ((begpos <= i.getPosition() && (i.getPosition()+i.getLen() > lastpos)))
    		    result += text.substring(i.getStart(),
    		   		                        lastpos-i.getPosition()+i.getStart()+1);
    		else
    		if ((begpos > i.getPosition() && (i.getPosition()+i.getLen()<=lastpos)))
    		  	result += text.substring(i.getStart() + (begpos-i.getPosition()),
    		  		                     i.getStart()+i.getLen());
    		else
    		if ((begpos > i.getPosition() && (i.getPosition()+i.getLen() > lastpos)))
             result += text.substring(i.getStart() + (begpos-i.getPosition()),
                  		                  (lastpos - i.getPosition()) + i.getStart()+1);*/
 			                             
    		
    		if ((ct.getPosition() <= begpos)
 		&& (begpos < ct.getPosition() + ct.getLen()))
    		{
    			int startpos = begpos-ct.getPosition()+ct.getStart();
    		
 			    if (lastpos < ct.getPosition() + ct.getLen())
    			{
    				return text.substring(startpos,lastpos-ct.getPosition()+ct.getStart()+1);
    			}else{
    				result = text.substring(startpos,ct.getStart()+ct.getLen());
    			}
    			continue;
    		}
    		if ((ct.getPosition() <= lastpos)
 		&& (lastpos < ct.getPosition() + ct.getLen()))
    		{
    			return result + text.substring(ct.getStart(),lastpos-ct.getPosition()+ct.getStart()+1);
    		}
    		if ((i.getPosition() > begpos)&&(lastpos > i.getPosition() + ct.getLen())){
    			result = result + text.substring(ct.getStart(),ct.getStart()+ct.getLen());
    		}
    	}
    	return result;    
    }
}
