/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TMLayoutContentCellContainer.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;




/**
 * This is an abstract class to support layout.A layout is an object which
 * manages the size of the container cell and the position of the children item. 
 * This class support content provider service to fill its content.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public abstract class TMLayoutContentCellContainer extends TAbstractCellContainer implements IMarginLayout, IContentProvider
{
   int     top, bottom, left, right;
   boolean reversed = false;
   
   int     spacing;
   
   
   public IContentProvider getContentProvider() {return this; }
   public ILayout          getLayout() { return this; }
  
 
	/**
	 * Builds a new container
	 */
	public TMLayoutContentCellContainer(IDItem i) 
	{
	    super(i);    
	}
   
   /** Returns the left margin */
   public int getLeftMargin()
   {
   	return left;
   }
   
   /** Returns the right margin */
   public int getRightMargin()
   {
   	return right;
   }
   
   /** Returns the top margin */
   public int getTopMargin()
   {
   	return top;
   }
   
   /** Returns the bottom margin */
   public int getBottomMargin()
   {
   	return bottom;
   }
   
   /** Sets the margin of the layout */
   public void setMargin(int l, int r, int t, int b)
   {
   	  left = l;
   	  right = r;
   	  top = t;
   	  bottom = b;
   }
   
   
   /** Returns the true if the layout is reversed (BiDi support) */
   public boolean isReversed() {
	  return reversed;
   }

   /** Sets the if the layout is reversed LEFT->RIGHT etc... */
   public void setReversed(boolean reverse) {
	this.reversed = reverse;
   }


   /** Returns the spacing between children in the layout */
	public int getSpacing() {
		    return spacing;
	}

	/** Sets the spacing between the children in the layout */
	public void setSpacing(int spacing) {
		    this.spacing = spacing;
	}
	
	/** Returns a new Rect which is equal to the cell size and position
	 * @see org.eclipse.tptp.platform.report.igc.util.internal.Rect
	 **/
	public IShape copyShape()
	{
	       return new Rect(this);      
	}
	  
	/**
	 * Just for debug session, dumps the content of the cell 
	 */
	public void dump(int level) 
	{
		  for (int i=0; i<level; i = i + 1)
			   System.out.print("  ");
			   
		  System.out.print("<cell x=\"" + getX() + "\" y=\"" + getY() 
									+ "\" w=\"" + getWidth() + "\" h=\"" + getHeight()
									+ "\"" );
			
	      
		  System.out.println(" type=\"bounding_box\">");
	      for (TAbstractCell c = getChild(); c != null; c = c.getNext())
	      {
	      		c.dump(level+1);    
	      }
		  for (int i=0; i<level; i = i + 1)
			     System.out.print("  "); 
	      
	     
		  System.out.println("</cell>");    
	}
}
