/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StyleEditorDialog.java,v 1.3 2008/05/23 14:12:20 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 14 janv. 2004
 *
 */
package org.eclipse.tptp.platform.report.ui.dialogs.internal;


import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
//import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.report.ReportCorePlugin;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.ui.swt.widgets.internal.StyleRegistryEditor;


/**
 * The StyleEditorDialog class provides a feedback on the JScrib
 * styles editor operation. This dialog list the style with the name
 * and shows controls to edit Font type and Size, Text colors and
 * preview the configuration in a text example.
 * 
 * @see JScribDialog
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class StyleEditorDialog extends JScribDialog 
{
	StyleRegistryEditor   widget;	
	DStyleRegistry        localRegistry;

	public StyleEditorDialog(Shell parent)
	{
		super(parent);
	}
	
	
	protected Control createDialogArea(Composite parent) 
	{	
		Composite composite = (Composite) super.createDialogArea(parent);
		widget = new StyleRegistryEditor(composite,SWT.NONE);
		widget.setStyleRegistry(localRegistry);
		GridData gd = new GridData();
		gd.widthHint = 400;
		widget.setLayoutData(gd);
		getShell().setText(ReportCorePlugin.translate("EDIT_STYLES")); //$NON-NLS-1$
		return composite;
	}
	

	protected void okPressed()
	{
		widget.applyUpdate();
		super.okPressed();
	}
	
	protected void applyPressed()
	{
		widget.applyUpdate();
		//Button bt = getButton(JSCRIB_APPLY_BUTTON);
		super.applyPressed();
	}
	
	/*
	 * Sets the style list which the editor dialog edits
	 */
	public void setStyles(DStyleRegistry s)
	{
		localRegistry = s;
		if (widget!=null && !widget.isDisposed())
			widget.setStyleRegistry(s);
	}

}
