/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ZoomAction.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 19 janv. 2004
 *
 */
package org.eclipse.tptp.platform.report.ui.editor.actions.internal;

import org.eclipse.jface.action.IAction;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTViewer;
import org.eclipse.tptp.platform.report.ui.dialogs.internal.ZoomEditorDialog;


/**
 * @author emiravet
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ZoomAction extends JScribEditorActionDelegate {

	ZoomEditorDialog zd;
	
	public void run(IAction a) 
	{
		SWTViewer[] viewers = getEditor().getSWTViewers();
		if (viewers.length == 0) return;
		
		if (zd==null)
		{	
	        zd = new ZoomEditorDialog(getEditor().getSite().getShell());
	        zd.applied.connect(this, "applyZoom()");
		}
	    
	    zd.setData(viewers[0].getContentsWidth(),viewers[0].getContentsHeight(),
	               viewers[0].getBounds().width, viewers[0].getBounds().height,
	               viewers[0].getZoom());
	    zd.open();
    };
	
	public void applyZoom()
	{
	    SWTViewer[] viewers = getEditor().getSWTViewers();
	    for (int i=0; i<viewers.length; i++)
		   viewers[i].setZoom(zd.getZoomFactor(), zd.isMaintainRatio());
	}
}
	