/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportEditor.java,v 1.13 2008/05/23 14:12:19 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


package org.eclipse.tptp.platform.report.ui.editor.internal;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DLinkUtil;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDDocument;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDLink;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDTaggedItem;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriter;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriterException;
import org.eclipse.tptp.platform.report.drivers.internal.IReader;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTViewer;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlDocumentReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlDocumentWriter;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.XSDXmlParserAdapter;
import org.eclipse.tptp.platform.report.tools.internal.DLinkResolver;
import org.eclipse.tptp.platform.report.tools.internal.SWTIImageProvider;
import org.eclipse.tptp.platform.report.ui.ReportUIPlugin;
import org.eclipse.tptp.platform.report.ui.editor.actions.internal.CopyAction;
import org.eclipse.tptp.platform.report.ui.editor.actions.internal.PrintAction;
import org.eclipse.tptp.platform.report.ui.editor.actions.internal.SelectAllAction;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.xsd.util.XSDParser;


/**
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 */

public class ReportEditor extends MultiPageEditorPart {
    
    
    private IPath amlFile = null; 
	
	private DocViewer views[];
	private DStyleRegistry styles = new DStyleRegistry();
	private int editorIndex;
	private static String html_browser = ReportUIPlugin.getString("ReportEditor.browserName"); //$NON-NLS-1$
	private SWTIImageProvider imgp;
    
    private class JSMLViewer extends SWTViewer {
        
        public JSMLViewer(Composite parent, int style) 
        {
            super(parent, style);
            
        }
        
        public void activateLink(IDLink link, Point p)
        {
            if (DLinkUtil.isInternalLink(link))
            {
              DLinkResolver r = new DLinkResolver(link);
              r.resolve(null);
            
              IDItem doc = r.getDocument();
              IDTaggedItem item = r.getTaggedItem();
            
              for (int i=0; i< views.length; i++)
              {
                if (views[i].document == doc)
                {
                    ReportEditor.this.setActivePage(views[i].page);
                    views[i].viewer.scrollTo(item.getTag());
                    return;
                }
              }
            }
            
            super.activateLink(link, p);
            
        }
    }
    
    private static class DocViewer 
    {
        public JSMLViewer viewer;
        public IDDocument document;
        public int page;
    }
    	
	public ReportEditor() {
		super();
	}
	
	public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
		super.init(site, editorInput);
		if (editorInput instanceof IPathEditorInput) {
		    amlFile = ((IPathEditorInput)editorInput).getPath();
		} else if (editorInput instanceof ILocationProvider) {
		    amlFile = ((ILocationProvider)editorInput).getPath(editorInput);
		} else {
            throw new PartInitException(ReportUIPlugin.getString("ReportEditor.BadFileType")+editorInput.getClass().getName()); //$NON-NLS-1$
		}
	}	
	
	
    /** opens a JSML file */ 
	public void openFile(String filename)
	{
	    //clear();
	    
	     IReader reader;
	     IDObject objs[];
	    
		 if (filename.endsWith(ReportUIPlugin.getString("ReportEditor.jsmlExtension"))) //$NON-NLS-1$
		 {
		      reader = new DXmlReader( new XSDXmlParserAdapter(new XSDParser()));  	      
		      reader.setStyleRegistry(styles);
		     
		      try {
			    	objs = reader.read( new FileInputStream(filename));
			  }
			  catch( Exception e )
			  {			    	
			      ErrorDialog.openError(getSite().getShell(),ReportUIPlugin.getString("ReportEditor.ParsingError"), null, null); //$NON-NLS-1$
			      return;
			  }
			  catch (Error err)
			  {
			      ErrorDialog.openError(getSite().getShell(),ReportUIPlugin.getString("ReportEditor.ParsingError"), null, null); //$NON-NLS-1$
			      return;
			  }
		 }
		 else
		 //if (filename.endsWith(".rxml"))
		 {
		     reader = new DXmlDocumentReader( new XSDXmlParserAdapter(new XSDParser()));
		     reader.setStyleRegistry(styles);
			    
			 try {
			   	objs = reader.read( new FileInputStream(filename));
			 }
			 catch( Exception e )
			 {
			    objs = new IDObject[1];
			    DDocument doc = new DDocument();
			    doc.addChild(new DText(ReportUIPlugin.getString("ReportEditor.FileError")+filename+"'\n"+ //$NON-NLS-1$ //$NON-NLS-2$
			                 e.getMessage()+"\n")); //$NON-NLS-1$
			  	//ErrorDialog.openError(getSite().getShell(),"Error When Parsing Report XML File", null, null);
			    objs[0] = doc;
			 }
			 catch (Error err)
			 {
                objs = new IDObject[1];
                DDocument doc = new DDocument();
                doc.addChild(new DText(ReportUIPlugin.getString("ReportEditor.FileError")+filename+"'\n"+ //$NON-NLS-1$ //$NON-NLS-2$
                             err.getMessage()+"\n")); //$NON-NLS-1$
                //ErrorDialog.openError(getSite().getShell(),"Error When Parsing Report XML File", null, null);
                objs[0] = doc; 
                 
			   	//ErrorDialog.openError(getSite().getShell(),"Error When Parsing Report XML File", null, null);
			   //	return;
			 }
		 }
		 /*else
		 {
		     objs = new IDObject[1];
		     DDocument doc = new DDocument("error", "Error Information");
		     doc.addChild(new DText("The extension of file '"+filename+"' is unknown"));
		     objs[0] = doc;
		 }*/
	    
	    
	    // computes the document number
	    int nbdoc=0;
	    for (int i=0; i<objs.length; i++)
	        if (objs[i] instanceof IDDocument) nbdoc++;
	    IDDocument[] documents = new IDDocument[nbdoc];
	    
	    if (nbdoc==0)
	    {
	        objs = new IDObject[1];
		    DDocument doc = new DDocument("error", ReportUIPlugin.getString("ReportEditor.errorDocTitle")); //$NON-NLS-1$ //$NON-NLS-2$
		    doc.addChild(new DText(ReportUIPlugin.getString("ReportEditor.noDocument")+filename+"'")); //$NON-NLS-1$ //$NON-NLS-2$
		    objs[0] = doc;
		    nbdoc=1;
	    }
	       
	    views = new DocViewer[nbdoc];
	             
	    int nudoc = 0;
	    
	    imgp= new SWTIImageProvider(getSite().getShell().getDisplay());
	   
	    File info = new File(filename);
	    imgp.addImageSearchPath(info.getParent());
	    
	    for (int i=0; i<objs.length; i++)
	    {
	    	if (objs[i] instanceof IDDocument)
	    	{	
	    	   views[nudoc] = new DocViewer();
	    	   Composite composite = new Composite(getContainer(), SWT.NONE);
	    	   FillLayout layout = new FillLayout(SWT.VERTICAL);
	    	   composite.setLayout(layout);   	   
	    	   views[nudoc].document = (IDDocument)objs[i];
	    	   views[nudoc].viewer = new JSMLViewer(composite,SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
	    	   views[nudoc].viewer.setBackground(new Color(composite.getDisplay(),255,255,255));
	    	   views[nudoc].viewer.setImageProvider(imgp);
	    	   views[nudoc].viewer.linkActivated.connect(this,"linkActivated(java.lang.String, org.eclipse.tptp.platform.report.core.internal.IDLink)"); //$NON-NLS-1$
	    	   //views[nudoc].viewer.linkHighlighted.connect(JScribEditor.class,"linkHighlighted(java.lang.String, org.eclipse.tptp.platform.report.core.internal.IDLink)");
	    	   views[nudoc].page = nudoc;
	    	   int index = addPage(composite);
	    	   setPageText(index, views[nudoc].document.getTitle());
	    	   views[nudoc].viewer.setContent( views[nudoc].document.getDocument() );
	    	   documents[nudoc] = views[nudoc].document;
	    	   nudoc++;
	    	}
	    }
	    
	    DLinkResolver.makeDocumentPool(documents);
	    
	}

	
	public void linkActivated(String str, IDLink link)
	{
	    if (!DLinkUtil.isInternalLink(link))
        {
            String path = DLinkUtil.getPath(link); 
            if (DLinkUtil.getMethod(link).equals("http")) //$NON-NLS-1$
            {
                try {
                   Runtime.getRuntime().exec( new String[]{html_browser, str} );
                }
                catch (IOException e)
        	    {
                    ErrorDialog err = new ErrorDialog(this.getEditorSite().getShell(), getTitle(), 
                            e.getMessage(), null, 0);
                    err.open();
        	        return;
        	    }
            }
            else
            if (DLinkUtil.getMethod(link).equals("file")) //$NON-NLS-1$
            {
                IWorkbench wb = ReportUIPlugin.getDefault().getWorkbench();
                IEditorDescriptor ed  = wb.getEditorRegistry().getDefaultEditor(path);
                if (ed==null)
                {
                    ed = wb.getEditorRegistry().getDefaultEditor("foo.txt"); //$NON-NLS-1$
                }
                
                try {
                  IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(new Path(path));
                  if(file != null) 
                    wb.getActiveWorkbenchWindow().getActivePage().openEditor(new FileEditorInput(file), ed.getId());
                }
                catch (PartInitException e)
                {
                    ErrorDialog err = new ErrorDialog(this.getEditorSite().getShell(), getTitle(), 
                              e.getMessage(), null, 0);
                    err.open();
                }
            }  
        } 
    }
		
	
	/*private void clear()
	{
	   for (int i=0; i< views.length; i++)
		   removePage(i);
	   styles.clear();
	}*/
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.MultiPageEditorPart#createPages()
	 */
	protected void createPages() {

		this.setPartName(amlFile.lastSegment());
		openFile(amlFile.toString());
	
		MakeAction();
	}
	
	private void MakeAction()
	{
		getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(),
						new PrintAction(this));
		getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId() ,
						new CopyAction(this));
		getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(),
				        new SelectAllAction(this));
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.EditorPart#doSave(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public void doSave(IProgressMonitor monitor) 
	{
		if (editorIndex == -1) return;
		
		getEditor(editorIndex).doSave(monitor);
		reload();
	}
	
	/**
	 * @see org.eclipse.ui.part.EditorPart#doSaveAs()
	 */
	public void doSaveAs() 
	{
	     FileDialog fd = new FileDialog(new Shell(Display.getDefault(), SWT.DIALOG_TRIM|SWT.RESIZE), SWT.SAVE);
	     fd.setFilterNames( new String[] {  ReportUIPlugin.getString("ReportEditor.rxmlFilter"), ReportUIPlugin.getString("ReportEditor.htmlFilter")} ); //$NON-NLS-1$ //$NON-NLS-2$
	     fd.setFilterExtensions( new String[] { "*.rxml", "*.html" } ); //$NON-NLS-1$ //$NON-NLS-2$
	  	 String filename = fd.open();
	  	 if (filename==null) return;
	  	 
	  	 IDObject objs[] = new IDObject[views.length];
	     for (int i=0; i< objs.length; i++)
	       objs[i] = views[i].document;
	  	 
	  	 if (filename.lastIndexOf(".rxml")!=-1) //$NON-NLS-1$
	  	 {
	  	   DXmlDocumentWriter aw = new DXmlDocumentWriter();
		   aw.setAutoIndentMode(true);
		  	  
		   try{
		       aw.write( new FileOutputStream(filename), objs );       
		   }
		   catch(Exception e ) 
		   {
		       ErrorDialog.openError(getSite().getShell(),filename+ReportUIPlugin.getString("ReportEditor.saveError"), null, null); //$NON-NLS-1$
		   }
	  	 }
	  	 else
	  	 if (filename.lastIndexOf(".html")!=-1) //$NON-NLS-1$
	  	 {
	  	     try {
	  	       DHtmlWriter.write(filename, objs, DHtmlWriter.GRAPHIC_SVG, imgp);
	  	     }
	  	     catch (DHtmlWriterException e)
	  	     {
	  	       ErrorDialog.openError(getSite().getShell(),e.getMessage(), null, null);
	  	     }
	  	 }
	}
	
	public void reload()
	{
		openFile(amlFile.toString());
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.EditorPart#gotoMarker(org.eclipse.core.resources.IMarker)
	 */
	public void gotoMarker(IMarker marker) 
	{
		
	}
	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.EditorPart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return true;
	}
	
	/**
	 * Returns the activate SWT viewer 
	 */
	public SWTViewer getActiveSWTViewer() {
		return views[getActivePage()].viewer;
	}
	
	/**
	 * Returns the SWT Viewers
	 */
	public SWTViewer[] getSWTViewers() {
	    SWTViewer[] swtv = new SWTViewer[views.length];
	    for (int i=0; i<swtv.length; i++)
	        swtv[i] = views[i].viewer;
	    return swtv;
	}

	/**
	 * Returns the styles.
	 */
	public DStyleRegistry getStyles() 
	{
		return styles;
	}
	
	/**
	 * Sets the active page
	 */
	public void setActiveSWTViewer(int page)
	{
	    setActivePage(page);
	}

}
