/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ScreenPreview.java,v 1.2 2008/05/23 14:12:16 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 20 janv. 2004
 *
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

/**
 * @author emiravet
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ScreenPreview extends Canvas {

	public static final int SCREEN_W = 200;
	public static final int SCREEN_H = 100;
	
	Rectangle windowRect;
	Rectangle pageRect;
	
	public ScreenPreview(Composite parent, int style)
	{
		super(parent, style|SWT.NO_BACKGROUND );
		addPaintListener(new PaintListener(){
			public void paintControl(PaintEvent event) {
				paintEvent(event);			
			}
		});
	}
	
	public void setRectangles(Rectangle wr, Rectangle pr)
	{
		windowRect = wr;
		pageRect = pr;
	    redraw();
	}

	public Point computeSize(int wHint, int hHint, boolean changed)
	{
		return new Point(SCREEN_W+1, SCREEN_H+1);
	}
	
	protected void paintEvent(PaintEvent event)
	{
		Rectangle r = event.gc.getClipping();
		
		Display disp = getDisplay();
		Color back = new Color( disp,176,176,176);
		Color pen = disp.getSystemColor( SWT.COLOR_BLACK );
		Color bpage = disp.getSystemColor( SWT.COLOR_WHITE );
		
		GC gc = event.gc;
		
		// draw screen
	
		if (windowRect==null) 
		{
		  gc.setBackground( getBackground() );
		  gc.fillRectangle( 0,0, SCREEN_W, SCREEN_H );
		  gc.setForeground( pen );
		  gc.drawRectangle( 0,0, SCREEN_W, SCREEN_H );
		  return;
		}
		
		Rectangle cdr = disp.getBounds();
		int sw = cdr.width;
		int sh = cdr.height;
		
        // draw window
		int ww = (int)(((float)windowRect.width / (float)sw) * (float)SCREEN_W);
		int wh = (int)(((float)windowRect.height / (float)sh) * (float)SCREEN_H);
		
		int wx = 0;
		int wy = 0;
		if ((getStyle() & SWT.CENTER)!=0)
		{	
			wx = (int)((SCREEN_W-ww)/2);
			wy = (int)((SCREEN_H-wh)/2);
		}
		else
		{
			wx = (int)(((float)windowRect.x / (float)sw) * (float)SCREEN_W);
			wy = (int)(((float)windowRect.y / (float)sh) * (float)SCREEN_H);
		}
		
		//ScreenPreview Background:
		gc.setBackground( getBackground() );
		gc.fillRectangle( 0,0, wx, SCREEN_H );
		gc.fillRectangle( wx+ww, 0, wx, SCREEN_H );
		gc.fillRectangle( wx, 0, ww, wy );
		gc.fillRectangle( wx, wy+wh, ww, wy+1 );
		gc.drawRectangle(0,0,SCREEN_W,SCREEN_H);
		
		gc.setBackground(back);
		gc.setForeground(pen);

		gc.fillRectangle(wx,wy,ww,wh);
		gc.drawRectangle(wx,wy,ww,wh);
		
		if (pageRect==null) return;
		
		// draw page
		int pw = (int)Math.round(( (pageRect.width * SCREEN_W ) / (float)sw ) );
		int ph = (int)(( (pageRect.height * SCREEN_H )/ (float)sh) );
		
		int px=wx;
		int py=wy;
		if ((getStyle() & SWT.CENTER)!=0)
		{	
			px += (int)((ww-pw)/2);
			//py += 0;
		}
		else
		{
			px += (int)Math.round(((pageRect.x * SCREEN_W) / (float)sw) +1 );
			py += (int)Math.round(((pageRect.y * SCREEN_H) / (float)sh) +1 );
		}
		ph -=2;

		
		if (pw>ww)
		{
			px = wx;
			pw = ww;
		}
		if (ph>wh)
		    ph = wh-1;
		
		gc.setBackground(bpage);
		gc.fillRectangle(px,py, pw, ph);
		gc.drawRectangle(px, py, pw, ph);
	}
	
}
