/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DPrinterPainter.java,v 1.2 2008/05/23 14:12:19 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.printer.internal;

import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTPainter;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellText;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;


/**
 * @author emiravet
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class DPrinterPainter extends SWTPainter {

	
	public void drawCell( PainterEvent pe )   
	{
		IDItem item = pe.cell.getItem();
		if(item == null) return;	
		
		Rect r = Rect.Intersection( pe.abs_cell_x, pe.abs_cell_y, pe.cell.getWidth(), pe.cell.getHeight(),
				pe.clipArea.getX(), pe.clipArea.getY(), pe.clipArea.getW(),  pe.clipArea.getH() );  
//System.out.println("Paint/drawCell/ cell intersection ? clip="+r+" pe.clipA="+pe.clipArea);
		if (r==null) return;	
		
		if (pe.cell.getChild()==null && (pe.cell instanceof TCellText))
		{	
			// in this case the painter draw only the leaf cells which are entire visible
			if (r.getH() < pe.cell.getHeight() || r.getW() < pe.cell.getWidth())
			{
				return;
			}
		}
		
		super.drawCell(pe);
	}

	
}
