/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DPrinterWriter.java,v 1.3 2008/05/23 14:12:19 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 30 sept. 2003
 */
package org.eclipse.tptp.platform.report.drivers.printer.internal;


import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.graphics.*;
import org.eclipse.tptp.platform.report.core.internal.DAbstractParagraph;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.IDDocument;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTPainter;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.ILayout;
import org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TCellParagraph;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTGC;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;
import org.eclipse.tptp.platform.report.tools.internal.SWTIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.SimpleProgressMonitor;

/**
 * Printer driver class.
 * This class provides a driver to print JScrib document on a printer.
 * The driver uses directly the printer protocol.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class DPrinterWriter implements Runnable
{
    IDItem    contentItem;
    String    jobTitle;
	Printer   printer;
	Rectangle clientArea;		// client area to print on
	int       pageWidth;		// width of a printer page in pixels
	int       pageHeight;       // height of printer page in pixels
	
   // int       top, bottom, right, left;   // margins
	
	private Shell          shell;
	private PrinterData    printerData;
    private IDIImageProvider iimage_provider;
    private IDProgressMonitor progressMonitor = new SimpleProgressMonitor();
    //private boolean        owner_image_provider = true;

    /**
     * Creates the printer driver.
     * @param _parent is the parent shell. It can be null. It used to 
     * show the configuration dialog.
     */		
    public DPrinterWriter(Shell _parent) 
    {
   	  shell = _parent;
   	  printerData = Printer.getDefaultPrinterData();
    }

   /**
    * Disposes of the resources and the <class>DPrinterWriter</class>.
    * Call this method when you haven't needed the driver.
    */
   void dispose() 
   {
    if( iimage_provider != null ) {
      iimage_provider.dispose();
      iimage_provider = null;
    }
   }

   
   /**
    * Initializes the print driver. builds the document and creates the painter.
    */
   private void print() 
   {
   	
	  Rectangle trim = printer.computeTrim(0, 0, 0, 0);
	  Point dpi = printer.getDPI();
		
	  clientArea = printer.getClientArea();
	  pageWidth  = clientArea.width;
	  pageHeight =  clientArea.height;
	  	
	  GC gc = new GC(printer);
	  SWTGC swtgc = new SWTGC(printer, gc);
	  
	  int align;
	  if (contentItem instanceof DAbstractParagraph)
	  	  align = ((DAbstractParagraph)contentItem).getAlignment();
	  else
	  	  align = DParagraph.LEFT;
	  
      // one inch margin around text
	  int mh = (dpi.x + trim.x)/8;
	  int mv = (dpi.y + trim.y)/8;
	  TCellParagraph contentCell = new TCellParagraph(contentItem, null, align);
	  contentCell.setMargin(mh, mh, mv, mv);
	 
	  Display disp = Display.getDefault();
	  contentCell.fillContent(contentItem, swtgc, getImageProvider(), getProgressMonitor(), new DTitleLevel(), new DListLevel(), false);
	  contentCell.computeSize((pageWidth*disp.getDPI().x)/dpi.x, ILayout.NO_SIZE_HINT, 1.0f, swtgc, getProgressMonitor());
	  contentCell.layout(1.0f, 0, getProgressMonitor());
	  	  
	  TPageSplitter sp = new TPageSplitter();
	  sp.setPageSize(pageWidth, pageHeight);
	  sp.split(contentCell, 1.0f, swtgc, getImageProvider(), getProgressMonitor(),
	  		   new DTitleLevel(), new DListLevel(), false, 0);
	  
	  //System.out.println("nb page = "+ sp.getPageCount());
	  	
	  SWTPainter  painter = new DPrinterPainter();
	  
	  SWTPainter.PainterEvent pe;
	  int y0 = (sp.getPageCount()>0)? sp.getPageAt(0).y : 0;
	  for (int nupage=0; nupage < sp.getPageCount(); nupage++)
	  {
	  	if (printerData.scope == PrinterData.PAGE_RANGE)
	  	{	
	  	   if (nupage+1 < printer.getPrinterData().startPage) continue;
	  	   if (nupage+1 > printer.getPrinterData().endPage) break;
	  	}
	  	
	  	TPageSplitter.Page page = sp.getPageAt(nupage);
	  	
	  	if (!printer.startPage()) break; 
	  	
	  	int ypos=0;
	  	// draw header
	  	if (page.header!=null)
	  	{	
	  	   pe = new SWTPainter.PainterEvent( swtgc, page.header,
	  	        1.0f, getImageProvider(),
				null, false,
				false,0,0,
				0,0,
				//view area in contents coordinates.
				clientArea.x, clientArea.y, page.header.getWidth(), page.header.getHeight(),
				//clip area in contents coordinates.
				0, 0, page.header.getWidth(), page.header.getHeight());
	  	   painter.drawCell(pe);
	  	   ypos += page.header.getHeight();
	  	}
	  	
	  	// draw body
	  	pe = new SWTPainter.PainterEvent( swtgc, contentCell, 
	  			1.0f, getImageProvider(),
				null, false,
				false,0,0,
				0,0,
				//view area in contents coordinates.
				page.x, page.y-ypos+y0-1, page.w, page.h+ypos,
				//clientArea.x, clientArea.y-ypos+oldph, clientArea.width, clientArea.height,
				//clip area in contents coordinates.
				0, page.y, /*ypos,*/ page.w, page.h);
	  	painter.drawCell(pe);
	  	
	  	// draw footer
	  	if (page.footer!=null)
	  	{
	  	   pe = new SWTPainter.PainterEvent( swtgc, page.footer, 
	  			1.0f, getImageProvider(),
				null, false,
				false,0,0,
				0,0,
				//view area in contents coordinates.
				clientArea.x, -clientArea.height+page.footer.getHeight(), page.footer.getWidth(), page.footer.getHeight(),
				//clip area in contents coordinates.
				0, 0, page.footer.getWidth(), page.footer.getHeight());
	  	
	  	   painter.drawCell(pe);
	  	}
	  	
	  	printer.endPage();
	  }
	  
	  contentCell.dispose();
	  gc.dispose();
	  swtgc.dispose();
   }

   
   /**
    * Prints the document's pages
    */
//   private void print() 
//   {
//	  int page = 0; //builder.getPageBegin();
//	  for (ITCell cpage = builder.getFirstCell(); cpage !=null; cpage = cpage.getNext())
//	  {
//	  	 page ++;
//	  	 if (page < builder.getPageBegin()) continue;
//	  	 if (page > builder.getPageEnd()) break;
//	  	 
//		 if (!printer.startPage()) break; 
////System.out.println("Printing "+document.getTitle()+" page "+(page)+"/"+builder.getPageCount());	  	
////System.out.println("Page size = ("+cpage.getX()+","+cpage.getY()+","+cpage.getWidth()+","+cpage.getHeight()+")");
//	 
//         SWTPainter.PainterEvent pe = new SWTPainter.PainterEvent( gc, cpage, 
//         		         printer, builder.getZoom(), builder.getImageProvider(),
//                         null, false,
//                         false,0,0,
//                         0,0,
//                         //view area in contents coordinates.
//                         clientArea.x, clientArea.y, clientArea.width, clientArea.height,
//                         //clip area in contents coordinates.
//                         clientArea.x, clientArea.y, clientArea.width, clientArea.height);
//         painter.drawCell( pe );
//		 printer.endPage();
//	  }
//   }
   
   
   /**
    * Returns the internla IImage provider used by this driver.
    */
   public IDIImageProvider getImageProvider() 
   {
     if( iimage_provider == null )
     {
       //Note: iimage_provider provide IImage for IGC, this must be done at pixel coordinates
       //even if device is printer (or other than display). To have right image creation
       //any iimage_provider must have a display as device.
       iimage_provider = new SWTIImageProvider( Display.getCurrent() );
     }
     return iimage_provider; 
   }

   /**
    * Starts a print job and prints the pages.
    * The document's name is used to set the job name.
    */
   public void run() 
   {
   	  if (contentItem==null) return;
   	  
      PrintDialog d = new PrintDialog(shell);
      printerData = d.open();
 
   	  if (printerData==null)
   	  {
   	  	return;
   	  }

	  String jobName = "Printing " + ((jobTitle==null)? "Unamed Document":jobTitle);

      printer = new Printer(printerData);			
	  if (printer.startJob(jobName)) 
	  {
		print();
		dispose();
		printer.endJob();			
	  }
   }
   
	/**
	 * @return the document which has been printing
	 */
	public IDItem getContentItem() 
	{
		return contentItem;
	}
	
	/**
	 * Sets the document which has been printing
	 * @param document
	 */
	public void setContentItem(IDItem rootItem) 
	{
		contentItem = rootItem;
		
		if (contentItem instanceof IDDocument)
			jobTitle = ((IDDocument)contentItem).getTitle();
	}

	/**
	 * Sets the document which has been printing
	 * @param document
	 */
	public void setDocument(IDDocument document) 
	{
		setContentItem(document);
	}


	/**
	 * @param provider
	 */
	public void setImageProvider( IDIImageProvider provider) 
	{
		//owner_image_provider = (iimage_provider == provider);
		iimage_provider = provider;
	}

	/**
	 * @return Returns the jobTitle.
	 */
	public String getJobTitle() {
		return jobTitle;
	}

	/**
	 * @param jobTitle The jobTitle to set.
	 */
	public void setJobTitle(String jobTitle) {
		this.jobTitle = jobTitle;
	}
	
//	/**
//	 * @param left, right, top, bottom margin in pixel
//	 */
//	public void setMargin(int _left, int _right, int _top, int _bottom)
//	{
//		top    = _top;
//		bottom = _bottom;
//		left   = _left;
//		right  = _right;
//	}

    public IDProgressMonitor getProgressMonitor() 
    {
        return progressMonitor;
    }
    
    public void setProgressMonitor(IDProgressMonitor progressMonitor) 
    {
        this.progressMonitor = progressMonitor;
    }
}
