/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ViewerRegistry.java,v 1.2 2008/05/23 14:12:21 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.ui.internal;

import java.util.Hashtable;
import java.util.Iterator;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.tptp.platform.report.core.internal.IDRegistry;
import org.eclipse.tptp.platform.report.signals.internal.Signal;


/**
 * A ViewerRegistry is a registry collecting SWTViewer objects and their name. 
 * A ViewerRegistry stores only one instance of SWTViewer if two SWTViewers are equals.
 * Before to store a new SWTViewer the registry checks if the SWTViewer doesn't exist in the
 * registry by calling the method <b>contains</b>.
 *
 * @see SWTViewer
 * @see #contains
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class ViewerRegistry implements IDRegistry, DisposeListener {

	/** 
	 * This signal is emitted each time a new viewer is added to this registry.
	 */
	public static final Signal sgn_putViewer = new Signal("putViewer(org.eclipse.tptp.platform.report.drivers.ui.internal.SWTViewer)");
	/** 
	 * This signal is emitted each time a viewer is removed to this registry.
	 */
	public static final Signal sgn_removeViewer = new Signal("removeViewer(String)");
	
	/** key: viewer's name, data: SWTViewer */
	private Hashtable viewers;  
	
	/**
	 * Creates an empty ViewerRegistry.
	 */
	public ViewerRegistry() {
	    viewers = new Hashtable();
	}

	/**
	 * Clears the registry
	 */
	public void clear() {
		viewers.clear();
	}

	/**
	 * Returns an iterator to access to all colors. 
	 */
	public Iterator iterator() {
	     return viewers.values().iterator();
	}
	 
	/**
	 * Returns true if the SWTViewer is already stored in the registry. 
	 */
	public boolean contains( SWTViewer v )
	{
		return viewers.contains(v); 
	}
	
	/**
	 * Returns true if the viewer name is already stored in the registry. 
	 */
	public boolean contains( String name )
	{
		return viewers.contains(name); 
	}
	
	/**
	 * Remove the color if stored in registry.
	 */
	public void removeViewer( String name )
	{
		viewers.remove( name );
	    sgn_removeViewer.emit( new Object[]{ name }  );
	}
	
	/**
	 * Update the viewer
	 * @param viewer updated viewer
	 */
	public void updateViewer ( SWTViewer viewer)
	{
		if (viewers == null ) return;
		String n = viewer.getViewerName();
		if (viewers.get(n) != null) {
			viewers.remove(n);
		    sgn_removeViewer.emit( new Object[]{ n }  );
			viewers.put(n, viewer);
			sgn_putViewer.emit( new Object[] {viewer});
		}
	}
	
	/**
	 * Put the color in the registry only if color isn't already stored.
	 */
	public boolean putViewer( String key, SWTViewer v ) 
	{
		if( v == null ) return false;
		if ( contains(key)) return false; // already stored
		viewers.put( key, v );
		v.addDisposeListener(this);
		//System.out.println("putViewer : " + key);
		sgn_putViewer.emit( new Object[] {v});
		return true;
	}
	
	/**
	 * Returns the registered viewer named name
	 * @param name name of the researched viewer
	 * @return the viewer
	 */
	public SWTViewer getViewer(String name) 
	{
		return (SWTViewer)viewers.get(name);
	}

	public void widgetDisposed(DisposeEvent e) {
		if ((e.getSource()) instanceof SWTViewer) {
			//System.out.println("getSource : " + ((SWTViewer)e.getSource()).getViewerName());
			removeViewer(((SWTViewer)e.getSource()).getViewerName());
			//System.out.println("removeViewer" );
		}

	}

}
