/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ILayout.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;



/**
 * This interface provides service to support layout mechanism. A layout is an object which
 * manages the size of the container cell and the position of the children item. 
 * To have a container with a good size and all good children position the following
 * calling sequence must be written:<br>
 * 
 * <PRE>
 * ILayout l = myContainer.getLayout();
 * l.computeSize(myContainer, 300,200,1.0f, myigc);
 * l.layout(myContainer, 0);
 * </PRE>
  <br>
 * The SWTViewer realizes this call automatically for its content when the size of the widget
 * is changed of when the method refresh is called
 * @see STWViewer#refresh
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public interface ILayout 
{
   /** no prefered size for the cell */
   public static final int NO_SIZE_HINT = -1; 
    
    
   /** Computes the size of the specified composite's client area according to 
    * this layout.  This method computes the size of the container and their children must be in order 
    * to position all children at their size inside the container. This method
    * tries to respect the prefered size given by the parameter (hintW, hintH). If it is
    * not possible or if hintW/hinH is equal to the value NO_SIZE_HINT the method 
    * computes the minimum size of the children bounding box to the
    * container.
    * @param cell is the cell container
    * @param hintW the prefered width size in pixel 
    * @param hinH the prefered height size in pixel
    * @param zoom the zoom value
    * @param gc the graphic context used to render the cell
    */
   public void computeSize(TAbstractCellContainer cell, int hintW, int hintH, float zoom, IGC gc,
                           IDProgressMonitor monitor);
   
   
   /** Lays out the children of the specified container according to this layout. 
    * This method positions the children cell of a container using 
    * the layout algorithm encoded by this layout. 
    * Children of the container are positioned in the client area of the container. 
    * The position of the container is not altered by this method. 
    * This method returns the last character position in the container. This number is the
    * number of character which appears in the container added to the value of the parameter
    * char_position 
    * @param cell is the cell container 
    * @param zoom the zoom value
    * @param char_position is the number of character which are before the container cell */ 
   public int  layout(TAbstractCellContainer cell, float zoom, int char_position,
                      IDProgressMonitor monitor); 
   
   
   /** Returns the true if the layout is reversed (BiDi support) */
   public boolean isReversed();

   /** Sets the if the layout is reversed LEFT->RIGHT etc... */
   public void setReversed(boolean reverse);

}
