/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ILineLayout.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


/**
 * Provides a base class for all layout which support line.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public abstract interface ILineLayout extends ILayout 
{

    /** 
     * provides an interface to access line information.
     */
	public interface ILine {
		
		/** Returns the first cell of the line */
		public TAbstractCell      getFirst();
		/** Returns the last cell of the line */
		public TAbstractCell      getLast();
		/** Returns the width in pixel of the line */
		public int         getWidth();
		/** Returns the height of the line */
		public int         getHeight();
		/** Returns the next line */
		public ILine       getNext();
	}
	
	/**
	 * Returns the width in pixel of the max line width.
	 */
	public abstract int getMaxLineWidth();

	/**
	 * Returns the height in pixel of all lines.
	 */
	public abstract int getLinesHeight();
	
	/**
	 * Returns the number of lines.
	 */
	public abstract int getLineCount();
	
	/**
	 * Returns the line at the position i.
	 */
	public abstract ILine getLineAt(int i);

	/**
	 * Returns the first line.
	 */
	public abstract ILine getFirstLine();
	
	/**
	 * Returns the last line.
	 */
	public abstract ILine getLastLine();
}
