/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TAbstractCell.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;


/**
 * Provides an abstract base class which is the basic item in an SWTViewer. A cell is a rectangle
 * which do not contain child TCell.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public abstract class TAbstractCell implements IRect
{
 
   protected  IDItem  item;
   protected  TAbstractCell  next;
   protected  TAbstractCell  previous;
   protected  TAbstractCellContainer  parent;
   protected int x,y,w,h;
   protected  int position;
   
   
   /** 
    * Computes the prefered size of the TCell. This method tries to respect the
    * prefered size given by the parameters hintW/hintH. If it is not possible or 
    * if the parameter's hintW/hintH value is ILayout.NO_SIZE_HINT the method computes
    * the minimum size of the cell.
    * */
   abstract public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor);
   
   
   /** Returns a new Rect which is equal to the cell size and position
    * @see org.eclipse.tptp.platform.report.igc.util.internal.Rect
    **/
   public IShape copyShape()
   {
       return new Rect(this);      
   }
   
   /**
    * Just for debug session, dumps the content of the cell 
    */
   abstract public void dump(int level); 
   
   /**
    * Builds a new cell and associates it with an IDItem.
    */
   public TAbstractCell(IDItem i) 
   {
   	 item = i;
   }
  
   /**
    * returns always the position
    */
   public int getPosition() 
   {
        return position;    
   }
   
   /**
    * Sets the value of the position property.
    */
   public void setPosition(int aPosition) 
   {
   	    position = aPosition;
   }
   
   /** Sets X,Y coordinates */
   public void setXY(int _x, int _y)
   {
      x = _x;
   	  y = _y;
   }
   
   /** returns the X coordinate of the cell */
   public int getX()
   {
   	  return x;
   }
   
   /** returns the Y coordinate of the cell */
   public int getY()
   {
   	  return y;
   }
   
   /** Sets the size of the cell */
   public void setSize(int _w, int _h)
   {
   	  w =  _w;
   	  h =  _h;
   }
  
   /** Returns the height of the cell */
   public IRect getBounds()
   {
      return this;    
   }
   
   /** Returns the height of the cell */
   public int getHeight()
   {
      return getH();    
   }
   
   /** Returns the width of the cell. */
   public int getWidth() 
   {
	  return getW();    
   }

   /** Returns the height of the cell */
   public int getH() 
   {
      return h;    
   }
   
   /** Returns the width of the cell. */
   public int getW() 
   {
	  return w;    
   }
   
   
   /** returns the item associated with the cell */
   public IDItem getItem() 
   {
         return item;    
   }
   
   /**
    * Sets the item which is associated with the cell.
    */
   public void setItem(IDItem aItem) 
   {
         item = aItem;    
   }
   
   /** returns true if the point is contained in the cell */
   public boolean contains(IPoint p)
   {
       return contains(p.getX(), p.getY());
   }
   
   /** returns true if the point is contained in the cell */
   public boolean contains(int _x, int _y) //IPoint p)
   {
       // check if the point is in the cell
	   return (((x <= _x) && (_y <= y + h)) && ((y <= _y) && (_x <= x + w)));
   }
  
   /** Detaches the cell of this parent */
   /*public void detach()
   {
   	  if (getPrevious()!=null)
   	      getPrevious().setNext(getNext());
   	  if (getNext()!=null )
   	  	  getNext().setPrevious(getPrevious());
   	  next     = null;
   	  previous = null;
   }*/
   
   /** Returns always null */
   public TAbstractCell getChild() 
   {
         return null;    
   }
   
   /** returns the sibling cell */
   public TAbstractCell getNext() 
   {
         return next;    
   }
   
   /** sets the sibling cell */
   public void setNext(TAbstractCell aNext) 
   {
         next = aNext;    
   }
   
   /** returns the previous cell */
   public TAbstractCell getPrevious() 
   {
      return previous;    
   }
   
   /** sets the previous cell */
   public void setPrevious(TAbstractCell aPrevious) 
   {
      previous = aPrevious;    
   }
   
   /** returns the parent */
   public TAbstractCellContainer getParent() 
   {
      return parent;    
   }
   
   /** sets the parent cell */
   public void setParent(TAbstractCellContainer aParent) 
   {
      parent = aParent;    
   }
   
   /** disposes the cell ( detaches and unassociates the IDItem )*/
   public void dispose() 
   {    
   }
   
   
   
   
   
  
   
}
