/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TAbstractCellContainer.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 1 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;



/**
 * This is the base class of cell container. Only this object can 
 * contain children TAbstractCell. To get the first child calls the method
 * @link TAbstractCellContainer#getChild(). This class is an abstract class
 * because all container must define a IContentProvider and a ILayout object.
 * If you have to define a new container cell to manage children cell for
 * a particular IDItem you should create a new container by inheriting of this
 * class and by implementing the method getContentProvider and getLayout.
 * You have to extend the @link TExtensibleContentProvider to create your new container
 * into the document hierarchy.
 * 
 * @see TExtensibleContentProvider
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public abstract class TAbstractCellContainer extends TAbstractCell
{
	private TAbstractCell child, last;
	boolean fixedSize= false;
	
	/**
	 * @return the layout of the container
	 */
	abstract public ILayout getLayout();

	/**
	 * @return the content provider of the container
	 */
	abstract public IContentProvider getContentProvider();
	
	/**
	 * Builds a new cell container which maps the item i 
	 */
	public TAbstractCellContainer(IDItem i) 
	{
	    super(i);    
	}
	
	/**
	 * Add a cell into the container
	 */
	public TAbstractCell addCell(TAbstractCell c) 
	{   
		if (child==null)
		{
			setChild(c);
			c.setPrevious(null);
		}
		else
		{
			last.setNext(c);
			c.setPrevious(last);
			
		}
		c.setParent(this);
		c.setNext(null);
		
		last = c;
		return c;
	}
	
	/** removes a cell from the container */
	public void removeCell(TAbstractCell c)
	{
	    if (c.getPrevious()!=null)
	        c.getPrevious().setNext(c.getNext());
	    else
	    {
	        child = c.getNext();
	        last = child;
	    }
	    
	    if (c.getNext()!=null)
	        c.getNext().setPrevious(c.getPrevious());
	    else
	        last = c.getPrevious();
	    
	    c.setParent(null);
	    c.setNext(null);
	    c.setPrevious(null);
	}
	
	/** @return true if the container contains the cell */
	public boolean hasCell(TAbstractCell c)
	{
	    for (TAbstractCell s = getChild(); s!=null; s=s.getNext())
	        if (s == c)
	            return true;
	        
	    return false;
	}
	
	/** inserts a cell into a container hierarchy */
	public TAbstractCell insertCell(TAbstractCell c, TAbstractCell previous) 
	{  
   	   
        if (previous != null) 
        {
            if (previous.getNext()!=null)
                previous.getNext().setPrevious(c);
            else
                last = c;
            
            c.setNext(previous.getNext());
            previous.setNext(c);
        }
        else
        {
            c.setNext(getChild());   
            getChild().setPrevious(c);
        }
        
        c.setParent(this);
   	    c.setPrevious(previous);
		return c;
	}
	
	
	/** Calls the fillContent method of the content provider
	 * 
	 * @see TAbstractCellContainer#getContentProvider()
	 * @see IContentProvider#fillContents */
	public void fillContent(IDItem item, IGC gc, IDIImageProvider pm, IDProgressMonitor monitor,
			                DTitleLevel titleLevel, DListLevel listLevel, boolean flatpopup)
	{
		getContentProvider().fillContent(this, item, gc, pm, monitor, titleLevel, listLevel, flatpopup);
	}

	/** 
	 * Calls the layout method compute size
	 * 
	 * @see TAbstractCellContainer#getLayout()
	 * @see ILayout#computeSize()  */
	public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor)
	{
	    getLayout().computeSize(this, hintW, hintH, zoom, gc, monitor);
	}
	
	/** Calls the layout method of the layout
	 * 
	 * @see TAbstractCellContainer#getLayout()
	 * @see ILayout#layout() */
	public int layout(float zoom, int charpos, IDProgressMonitor monitor)
	{
		return getLayout().layout(this, zoom, charpos, monitor);
	}
	
	
	/**
	 * Returns true if the size of the cell is fixed and cannot be streched.
	 */
     public boolean isFixedSize() {
	  return fixedSize;
	 }

	/**
	 * @param fixedSize The fixedSize to set.
	 */
	public void setFixedSize(boolean fixedSize) {
	  this.fixedSize = fixedSize;
	}

	/**		*/
	public TAbstractCell getChild() 
	{
	   return child;    
	}
   
	/**	*/
	public void setChild(TAbstractCell aChild) 
	{
	   child = aChild;    
	}
	
	/** calls the dispose methods on the children */
	public void dispose() 
	{
		for (TAbstractCell c = getChild(); c!=null; c=c.getNext())
		{
		    c.dispose();
		}
	}

	/**
	 * @return Returns the last.
	 */
	public TAbstractCell getLast() {
		return last;
	}

	/** @return the child number */
	public int getChildCount()
	{
	   int nbchild=0;
	   for (TAbstractCell c = getChild(); c!=null; c=c.getNext())
	     nbchild++;
	   return nbchild;
	}
}
