/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCell.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/



package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;


/**
 * Provides an implementation of the base class TAbstractCell. This class is used by the
 * TExtensibleContentProvider to allocate new cell for IDItem which have been rendering
 * in the SWTViewer. 
 * 
 * @see  TExtensibleContentProvider
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *  
 */
public class  TCell extends TAbstractCell
{
   
   /**
    * Builds a new cell and associates it with an IDItem.
    */
   public TCell(IDItem i) 
   {
       super(i);
   }
   

   /** 
    * This implementation do nothing
    * @see TAbstractCell#computeSize(int, int, float, IGC)
    * */
   public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor)
   {}
   
   
   
   /**
    * Just for debug session, dumps the content of the cell 
    */
   public void dump(int level) 
   {
	  for (int i=0; i<level; i = i + 1)
		   System.out.print("  ");
		   
	  System.out.print("<cell x=\"" + getX() + "\" y=\"" + getY() 
								+ "\" w=\"" + getWidth() + "\" h=\"" + getHeight()
								+ "\"" );
     
	  System.out.println("</cell>");    
   }
   
}
