/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellBorder.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


import org.eclipse.tptp.platform.report.core.internal.DBorder;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;


/**
 * Specialized TCell for DFolder item.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class TCellBorder extends TAbstractCellContainer implements ILayout, IContentProvider, ICarriageReturn
{
  public static final int MARGIN = 3;
  private static final int SPACING = 2;
  
  protected boolean       reversed_ ;
  
  public TCellBorder( DBorder item )
  {
    super( item );
  }
  
  public ILayout getLayout() { return this; }
  public IContentProvider getContentProvider() { return this; }
  public IShape copyShape() { return this; }

  public void dump(int level)
  {
    // TODO Auto-generated method stub    
  }

  /** @return current size of line type used by DBorder of this cell */
  public int getBorderSize()
  {
    DBorder border = (DBorder)getItem();
    int line_size=0;
    int line_type = border.getLineType();
    for( int i=0,m=1; i<8; i++,m<<=1 )
    {
      if( (m&line_type)!=0) line_size=i+1;
    }
    return line_size;
  }
  
  public void computeSize(TAbstractCellContainer cell, int hintW, int hintH, float zoom, IGC gc,
                          IDProgressMonitor monitor) 
  {

    int c_hintW=hintW, c_hintH=hintH;
    DBorder border = (DBorder)cell.getItem();
    
    int border_size= getBorderSize();
     
    int shadow =  border.getShadowDepth();
    int lm = MARGIN+border_size;
    int tm = MARGIN+border_size;
    int rm = MARGIN+border_size;
    int bm = MARGIN+border_size;
    switch( border.getShadowType() )
    {
    case DBorder.S_NONE :
      shadow=0; break;
    case DBorder.S_SOLID : 
    case DBorder.S_GRADIENT : 
      rm += shadow; bm += shadow; break;
    case DBorder.S_HALO:
      lm += shadow; rm += shadow;
      tm += shadow; bm += shadow; break;
    }
    if( c_hintW > 0 ) c_hintW -= lm+rm;
    if( c_hintH > 0 ) c_hintH -= tm+bm;
    
    int cw=0, ch=0;
    //child are layouted vertically
    for( TAbstractCell c=getChild(); c!=null; c=c.getNext() )
    {
      c.computeSize( c_hintW, c_hintH, zoom, gc, monitor );
      cw = Math.max( cw, c.getW() );
      ch += SPACING + c.getH();
    }
    ch -= SPACING;
    setSize( lm+cw+rm, tm+ch+bm);
  }

  public int layout(TAbstractCellContainer cell, float zoom, int char_position,
                    IDProgressMonitor monitor)
  {
    cell.setPosition(char_position);
    DBorder border = (DBorder)cell.getItem();
    
    int border_size= getBorderSize();
    if( border.getShadowType()==DBorder.S_HALO) border_size += border.getShadowDepth();
        
    int x = reversed_ ? cell.getW()-MARGIN-border_size : border_size+MARGIN; 
    int y = MARGIN + border_size ;
    
    for( TAbstractCell c=getChild(); c!=null; c=c.getNext() )
    {
      c.setXY( reversed_ ? x-c.getW() : x, y );
      c.setPosition( char_position );
      
      y += c.getH() + SPACING ;
      
      if( c instanceof TAbstractCellContainer )
      {
        TAbstractCellContainer cc = (TAbstractCellContainer)c;
        char_position = cc.getLayout().layout( cc, zoom, char_position, monitor );
      }
      else if ( c instanceof TCellText )
      {
        char_position += ((TCellText)c).getLen();
      }      
    }
    
    return char_position;
  }

  public boolean isReversed() { return reversed_; }
  public void setReversed( boolean _reversed ) { reversed_ = _reversed; }

  private class Arg implements TExtensibleContentProvider.IArg
  {
    protected DTitleLevel titleLevel_;
    protected DListLevel listLevel_;
    protected boolean flatPopup_;
    protected boolean draw_popup_;
    protected IGC gc_;
    protected IDIImageProvider pm_;
    protected IDProgressMonitor progressm;
    public Arg( IGC gc, IDIImageProvider pm, IDProgressMonitor progress, DTitleLevel titleLevel, DListLevel listLevel, boolean flatPopup)
    {
      gc_=gc;
      pm_=pm;
      titleLevel_=titleLevel;
      listLevel_=listLevel;
      flatPopup_=flatPopup;
      progressm = progress;
    }
    public ILayout getLayout() { return TCellBorder.this; }
    public TAbstractCellContainer getContainer() { return TCellBorder.this; }
    public TAbstractCell getCell() { return TCellBorder.this; }
    public DTitleLevel getTitleLevel() { return titleLevel_; }
    public DListLevel getListLevel() { return listLevel_; }
    public boolean isFlatPopup() { return flatPopup_; }
    public boolean isDrawPopup() { return draw_popup_; }
    public void setDrawPopup(boolean v) {}
    public IGC getGc() { return gc_; }
    public IDIImageProvider getImageProvider() { return pm_; }
    public IDProgressMonitor getProgressMonitor() { return progressm; }
    protected boolean first = true;
    public void addReturnValue(TAbstractCell arg) 
    {      
      TCellBorder.this.addCell( arg );
    }
  };
  

  public void fillContent(TAbstractCellContainer cell, IDItem fitem, final IGC gc, final IDIImageProvider pm, 
          IDProgressMonitor monitor, final DTitleLevel titleLevel, final DListLevel listLevel, final boolean flatPopup) 
  {
    if( !(item instanceof DBorder) ) return ;
    DBorder border = (DBorder)fitem;
    
    Arg arg = new Arg( gc, pm, monitor, titleLevel, listLevel, flatPopup ); 
    
    TExtensibleContentProvider ext = TExtensibleContentProvider.getInstance();    
    ext.doChildrenItem( border, ext, arg );    
  }

  public boolean hasCRBefore() {
    return false;
  }


  public boolean hasCRAfter() {
    return false;
  }

}
