/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellContainer.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;




/**
 * This is an abstract class to support layout.A layout is an object which
 * manages the size of the container cell and the position of the children item. 
 * This class support content provider service to fill its content.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class TCellContainer extends TAbstractCellContainer
{
    int     top, bottom, left, right;
    int     spacing;
    private IContentProvider  contentProvider;
    private ILayout           layout;
  
 
	/**
	 * Builds a new container
	 */
	public TCellContainer(IDItem i) 
	{
	    super(i);    
	}
	
	/**
	 * Builds a new container
	 */
	public TCellContainer(IDItem i, ILayout layout) 
	{
	    super(i);   
	    this.layout = layout;
	}
   	
	/** Returns a new Rect which is equal to the cell size and position
	 * @see org.eclipse.tptp.platform.report.igc.util.internal.Rect
	 **/
	public IShape copyShape()
	{
	       return new Rect(this);      
	}
	  
	/**
	 * Just for debug session, dumps the content of the cell 
	 */
	public void dump(int level) 
	{
		  for (int i=0; i<level; i = i + 1)
			   System.out.print("  ");
			   
		  System.out.print("<cell x=\"" + getX() + "\" y=\"" + getY() 
									+ "\" w=\"" + getWidth() + "\" h=\"" + getHeight()
									+ "\"" );
			
	      
		  System.out.println(" type=\"bounding_box\">");
	      for (TAbstractCell c = getChild(); c != null; c = c.getNext())
	      {
	      		c.dump(level+1);    
	      }
		  for (int i=0; i<level; i = i + 1)
			     System.out.print("  "); 
	      
	     
		  System.out.println("</cell>");    
	}

	public IContentProvider getContentProvider() {
         return contentProvider;
    }

	public void setContentProvider(IContentProvider contentProvider) {
         this.contentProvider = contentProvider;
    }

	public ILayout getLayout() {
        return layout;
    }

	public void setLayout(ILayout layout) {
        this.layout = layout;
    }
}
