/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellData.java,v 1.4 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 10 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;
import org.eclipse.tptp.platform.report.tools.internal.IVObject;


/**
 * Add a generic 'data' (Object) field in a TCell.
 * What is stored in data is the discretion of user.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class TCellData extends TAbstractCell implements IVObject
{
   private Object data;
   
   
   /**
    * Create a null data TCellData.
    */
   public TCellData(IDItem i) 
   {
   	 super (i);
   }
   
   /**
    * set object to null, and call super.dispose().
    * @see IVObject#setObject()
    */
   public void dispose()
   {
     setObject( null );
     super.dispose();
   }
   
   /**
    * @return current data value associated with this cell.
    */
   public Object getObject()
   {
     return data;
   }
   
   /**
    * Change value of current data. Replace previous data.
    * If current data is an instanceof IDispose, call dispose() method before replace.
    * @param data the new data value.
    */
   public void setObject( Object data )
   {
     if( this.data instanceof IDisposable )
     {
       ((IDisposable)this.data).dispose();
     }
     this.data = data;
   }

   /**
    * @see org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell#computeSize(int, int, float, org.eclipse.tptp.platform.report.igc.internal.IGC, org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor)
    */
   public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor) 
   {}

   /**
    * @see org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell#dump(int)
    */
   public void dump(int level)
   {}
   
  
   
}
