/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellFolder.java,v 1.3 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.tptp.platform.report.core.internal.DFolder;
import org.eclipse.tptp.platform.report.core.internal.DFolderModel;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;


/**
 * Specialized TCell for DFolder item.
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class TCellFolder extends TAbstractCellContainer implements ILayout, IContentProvider, ICarriageReturn
{
  private static final int H_SPACING = 2;
  private static final int V_SPACING = 2;
  
  protected TCellSymbol   symbol_cell_;
  protected ArrayList     header_cells_; //as one IDItem (header) might produce several TCell (including focus marker) 
  protected ArrayList     body_cells_;
  protected boolean       reversed_ ;
  
  {
    header_cells_ = new ArrayList();
    body_cells_ = new ArrayList();
  }
  
  public TCellFolder( DFolder item )
  {
    super( item );
  }
  
 /* public TCellFolder( DFolder i, TAbstractCell parent, TAbstractCell previous) 
  {
    super(i, parent, previous); 
  }*/
  
  public TCellSymbol getSymbolCell() { return symbol_cell_; }
  public Iterator getHeaderCellIterator() { return header_cells_!=null ? header_cells_.iterator() : null; }
  public Iterator getBodyCellIterator() { return body_cells_!=null ? body_cells_.iterator() : null; }
  
  public ILayout getLayout() { return this; }

  public IContentProvider getContentProvider() { return this; }

  public IShape copyShape() { return this; }

  public void dump(int level)
  {
    // TODO Auto-generated method stub    
  }

  public void computeSize(TAbstractCellContainer cell, int hintW, int hintH, float zoom, IGC gc,
                          IDProgressMonitor monitor) 
  {
    if( symbol_cell_==null ) return ;
    symbol_cell_.computeSize( ILayout.NO_SIZE_HINT, ILayout.NO_SIZE_HINT, zoom, gc );
    
    //header cells are layouted horizontally
    int hw = symbol_cell_.getW();
    int hh = symbol_cell_.getH();
    int h_hintW = hintW ;
    if( h_hintW> 0 ) h_hintW -= 2*H_SPACING + symbol_cell_.getW();
    for( Iterator I=header_cells_.iterator(); I.hasNext(); )
    {
      TAbstractCell c = (TAbstractCell)I.next();
      c.computeSize( h_hintW, hintH, zoom, gc, monitor );
      hw += 2*H_SPACING + c.getW();
      hh = Math.max( c.getH(), hh );
    }
    
    DFolderModel m = ((DFolder)getItem()).getFolderModel();
    if( m == null ) m = DFolderModel.GetDefault();
    int indentation=0;
    int b_hintW = hintW;
    if( m.isIndented() )
    {
      indentation += symbol_cell_.getW()+2*H_SPACING;
      if( hintW > 0 ) b_hintW = Math.max( 0, hintW-indentation );
    }
    
    int bw = 0;
    int bh = 0;    
    for( Iterator I=body_cells_.iterator(); I.hasNext(); )
    {
      TAbstractCell c = (TAbstractCell)I.next();
      c.computeSize( b_hintW, hintH, zoom, gc, monitor );
      bw = Math.max( bw, c.getW() );
      bh +=  V_SPACING + c.getH();
    }
    bw += indentation;
    
    int cw = Math.max( hw, bw );    
    if( hintW > cw ) cw = hintW;
    
    int ch = hh + V_SPACING + bh ;
    if( hintH > ch ) ch = hintH;
    
    cell.setSize( cw, ch );
  }

  public int layout(TAbstractCellContainer cell, float zoom, int char_position, IDProgressMonitor monitor)
  {
    cell.setPosition(char_position);
    
    int x = reversed_ ? cell.getW()-H_SPACING-symbol_cell_.getW()  : H_SPACING; 
    symbol_cell_.setXY( x, V_SPACING );

    //header cells are layouted horizontally
    if( reversed_ ) x -= H_SPACING; else x += symbol_cell_.getW()+H_SPACING;
    int hh = symbol_cell_.getH()+V_SPACING;
    for( Iterator I=header_cells_.iterator(); I.hasNext(); )
    {
      TAbstractCell c = (TAbstractCell)I.next();
      if( reversed_ ) x -= c.getW();
      c.setXY( x, 0);
      c.setPosition( char_position );
      hh = Math.max( hh, c.getH() );
      
      if( reversed_ ) x -=  H_SPACING; else x += c.getW()+H_SPACING;
      
      if( c instanceof TAbstractCellContainer )
      {
        TAbstractCellContainer cc = (TAbstractCellContainer)c;
        char_position = cc.getLayout().layout( cc, zoom, char_position, monitor );
      }
      else if ( c instanceof TCellText )
      {
        char_position += ((TCellText)c).getLen();
      }
    }
    
    //body cells are layouted vertically
    int y = hh + V_SPACING;
    x = reversed_ ? cell.getW() : 0;
    DFolderModel m = ((DFolder)getItem()).getFolderModel();
    if( m == null ) m = DFolderModel.GetDefault();
    if( m.isIndented() )
    {
      int sym_w = symbol_cell_.getW()+2*H_SPACING;;
      if( reversed_ ) 
        x -= sym_w ;
      else
        x += sym_w ;
    }
    
    for( Iterator I=body_cells_.iterator(); I.hasNext(); )
    {
      TAbstractCell c = (TAbstractCell)I.next();
      c.setXY( reversed_ ? x-c.getW() : x , y );
      c.setPosition( char_position );
    
      y += c.getH()+2*V_SPACING;
      
      if( c instanceof TAbstractCellContainer )
      {
        TAbstractCellContainer cc = (TAbstractCellContainer)c;
        char_position = cc.getLayout().layout( cc, zoom, char_position, monitor );
      }
      else if ( c instanceof TCellText )
      {
        char_position += ((TCellText)c).getLen();
      }
    }
    
    return char_position;
  }

  public boolean isReversed() { return reversed_; }
  public void setReversed( boolean _reversed ) { reversed_ = _reversed; }

  private class Arg implements TExtensibleContentProvider.IArg
  {
    protected DTitleLevel titleLevel_;
    protected DListLevel listLevel_;
    protected boolean flatPopup_;
    protected boolean draw_popup_;
    protected IGC gc_;
    protected IDIImageProvider pm_;
    protected IDProgressMonitor progressm;
    public Arg( IGC gc, IDIImageProvider pm, IDProgressMonitor monitor, DTitleLevel titleLevel, DListLevel listLevel, boolean flatPopup)
    {
      gc_=gc;
      pm_=pm;
      titleLevel_=titleLevel;
      listLevel_=listLevel;
      flatPopup_=flatPopup;
      progressm = monitor;
    }
    public ILayout getLayout() { return TCellFolder.this; }
    public TAbstractCellContainer getContainer() { return TCellFolder.this; }
    public TAbstractCell getCell() { return TCellFolder.this; }
    public DTitleLevel getTitleLevel() { return titleLevel_; }
    public DListLevel getListLevel() { return listLevel_; }
    public boolean isFlatPopup() { return flatPopup_; }
    public boolean isDrawPopup() { return draw_popup_; }
    public void setDrawPopup(boolean v) {}
    public IGC getGc() { return gc_; }
    public IDIImageProvider getImageProvider() { return pm_; }
    public IDProgressMonitor getProgressMonitor() { return progressm; }
    protected boolean first = true;
    public void addReturnValue(TAbstractCell arg) 
    {
      IDItem ai = arg.getItem();
      IDItem hi = TCellFolder.this.getItem().getFirstChild();
      //as more than one cell could belong from header item...
      boolean is_header= false;
      while( ai!=null )
      {
        if( ai==hi ) { is_header=true; break;}
        ai = ai.getParent();
      }
      if( is_header )
      {
        header_cells_.add( arg );
        first=false;
      } else {
        body_cells_.add( arg );
      }
      TCellFolder.this.addCell( arg );
    }
  };
  

  public void fillContent(TAbstractCellContainer cell, IDItem fitem, final IGC gc, final IDIImageProvider pm, IDProgressMonitor monitor, final DTitleLevel titleLevel, final DListLevel listLevel, final boolean flatPopup) 
  {
    if( !(item instanceof DFolder) ) return ;
    DFolder folder = (DFolder)fitem;
    
    IDItem header = folder.getFirstChild();
    if( header==null ) return ;
    
    symbol_cell_ = new TCellSymbol( folder );

    //final TCellFolder cfolder = (TCellFolder)cell;
    
    Arg arg = new Arg( gc, pm, monitor, titleLevel,  listLevel, flatPopup ); 
    
    TExtensibleContentProvider ext = TExtensibleContentProvider.getInstance();
    
    boolean opened = folder.isOpen();
    
    //boolean first=true;
    for( IDItem item=folder.getFirstChild(); item!=null; item=item.getNext() )
    {
      ext.invokeDoMethod( item, ext, arg );
      if( !opened ) break;
    }
  }


  public boolean hasCRBefore() {
    return true;
  }


  public boolean hasCRAfter() {
    return true;
  }

}
