/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellIterator.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 7 janv. 2004
 *
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


/**
 * Provides an iterator for ITCell item
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class TCellIterator {
	
	TAbstractCell current;
	
	/**
	 * Creates an interator from a ITCell
	 */
	public TCellIterator(TAbstractCell i)
	{
		current = i;
	}
	
	/**
	 * Returns the iterator of the current item.
	 */
	public TAbstractCell getCurrent() { return current; }
	
   
	/**
	 * Returns the iterator of the first child.
	 */
	public TAbstractCell getNext()
	{
		if (current == null) return current;
   	
		if (current.getChild() != null)  
		{
			current = current.getChild();
		}
		else
		if (current.getNext() != null)
		{
			current = current.getNext();
		}
		else
		{
		   current = current.getParent();
   	      
		   while (current != null)
		   {
			  if (current.getNext() != null)
			  {
				  current = current.getNext();
				  return current;
			  }
  			  current = current.getParent();
		   }
		}
		return current;    
	}
   
	/**
	 * Returns the iterator of the last child.
	 */
	public TAbstractCell getPrevious()
	{
		if (current == null) return current;
   	
   	    
   	    if ((current.getPrevious() == null) && (current.getParent()!=null))
   	    {
   	    	// recherche du dernier fils
			current = current.getParent();	
			while((current!=null) && (current.getChild() != null))
			{
				for (TAbstractCell c=current.getChild(); c!=null; c=c.getNext())
				{
					if (c.getNext()==null)
					{
					   current = c;
					   break;
					}
				 }
			}
   	    }
   	    else
		    current = current.getPrevious();
   	    
		return current; 
	}
	
}
