/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellLinePrefix.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 5 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;


/**
 * Enter here your comment
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class TCellLinePrefix extends TAbstractCell
{
   private ISymbol symbol;
   private IDItem  entryItem;
   private int     level;
   private String  number;
   
   public TCellLinePrefix(IDItem i)
   {
   	  super(i);
	  symbol = DSymbolRegistry.GetOval();
   }
   
   public TCellLinePrefix(IDItem i, ISymbol _symbol, IDItem ei, int _level)
   {
   	  super(i);
	  symbol    = _symbol; 
	  entryItem = ei;
	  level = _level;
   }
   
   public TCellLinePrefix(IDItem i, String _number, IDItem ei, int _level)
   {
   	  super(i);
      number = _number;
	  entryItem = ei;
	  //setLeftMargin(_level*5);
	  level = _level;
   }
   
   public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor)
   {
	  IFont sfont = IGCDStyle.GetFont( getEntryItem(), zoom );
	  IFont oldFont = gc.setFont(sfont);
	  
	  if (symbol==null && getNumber()!=null)
	  {
	  	 ISize p = gc.textExtent(getNumber());
	  	 setSize(p.getW(), p.getH());
	  }
	  else
	  {
	  	 int sizeH = gc.getFontMetrics().getHeight();
	  	 setSize(sizeH/3, sizeH);
	  }
	  
	  gc.setFont(oldFont);
   }

   /**
    * @return
    */
   public ISymbol getSymbol() 
   {
	   return symbol;
   }

   /**
    * @param symbol
    */
   public void setSymbol(ISymbol symbol) 
   {
	   this.symbol = symbol;
   }

   /**
    * @return
    */
   public IDItem getEntryItem() 
   {
	   return entryItem;
   }

   /**
    * @param item
    */
   public void setEntryItem(IDItem item) 
   {
	   entryItem = item;
   }
   

   /**
    * @return Returns the number.
    */
   public String getNumber() {
     return number;
   }
   /**
    * @param number The number to set.
    */
   public void setNumber(String number) {
     this.number = number;
   }
   /**
    * @return Returns the margin.
    */
   public int getLevel() {
     return level;
   }
   /**
    * @param margin The margin to set.
    */
   public void setLevel(int margin) {
     this.level = margin;
   }

   /** (non-Javadoc)
    * @see org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell#dump(int)
    */
   public void dump(int level) 
   {} 

}
