/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellParagraph.java,v 1.3 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/*
 * Created on 19 fvr. 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;



import org.eclipse.tptp.platform.report.core.internal.*;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IFontMetrics;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.tools.internal.DAlignment;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;


/**
 * Provides a layout which is available to manage paragraph text
 * format. A Paragraph layout contains several lines and can support
 * alignment
 * 
 * @see TCellParagraph#setAlignment
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class TCellParagraph extends TMLayoutContentCellContainer implements ILineLayout
{
	private class Line implements ILine {
		
	   public TAbstractCell      first;
	   public TAbstractCell      last;
	   public int         width;
	   public int         height;
	   public Line        next;
	   
	   public TAbstractCell getFirst() {return first; }
	   public TAbstractCell getLast()  {return last;}
	   public int    getWidth() {return width; }
	   public int    getHeight() {return height; }
	   public ILine  getNext()  {return next; }
    }		
	
	private class InfoP implements TExtensibleContentProvider.IArg {

		public TAbstractCellContainer cell;
		public TAbstractCell          currentCell;
		public IGC              gc;
		public IDIImageProvider imageProvider;
		public int             hintW;
		public int             hintH;
		public float           zoom;
		public boolean         flatpopup;
		public boolean         drawPopup;
		public IDProgressMonitor pm;
	
				
		public int             alignment;
		public int             position;
		
		public int             xoffset;
		
		DListLevel             listLevel;
		DTitleLevel            titleLevel;
		
		public IGC              getGc()            { return gc; }
		public IDIImageProvider  getImageProvider() { return imageProvider; }
		public DListLevel      getListLevel()     { return listLevel; }
		public DTitleLevel     getTitleLevel()    { return titleLevel; }
		
		public boolean         isDrawPopup()      { return drawPopup; }
		public boolean         isFlatPopup()      { return flatpopup; }
		public void            setDrawPopup(boolean v) {drawPopup = v;}
		
		public TAbstractCellContainer getContainer()     { return cell; }
		public TAbstractCell          getCell()          { return currentCell; }
		public ILayout         getLayout()        { return TCellParagraph.this; }
		public IDProgressMonitor  getProgressMonitor()   { return pm; }
		
		
		public void addReturnValue(TAbstractCell c)
		{
			currentCell = cell.addCell(c);
		}
	}
	
	private class Range
	{
		int start;
		int end;
	}
	
	Line       firstLine;
	Line       lastLine;

	float      zoom = 1.0f;
	int        alignment = DParagraph.LEFT;
	
	int        maxLineWidth;
	int        linesHeight;
	
	
	private void newLine()
	{
		Line l = new Line();
		
		if (firstLine==null)
			firstLine = l;
		else
		{
			lastLine.next = l;
		}
			
		lastLine = l;
	}
	
	private void newLineSpacing(int spacing)
	{
		Line l = new Line();
		l.height = spacing;

		if (firstLine==null)
			firstLine = l;
		else
		{
			lastLine.next = l;
		}
		
		linesHeight += l.height;
		lastLine = l;
		
		newLine();
	}
	
	private void addCellInLine(TAbstractCell c)
	{
		Line currentLine = lastLine; 
		
		if (currentLine.first==null)
			currentLine.first = c;
		currentLine.last = c;
		currentLine.width += c.getWidth();
		
		maxLineWidth = Math.max(maxLineWidth, currentLine.width);
		linesHeight = Math.max(linesHeight, linesHeight+ (c.getHeight() - currentLine.height));
		
		currentLine.height = Math.max(currentLine.height, c.getHeight());
	}
	
	private void addCarriageReturn(int h)
	{
		linesHeight = Math.max(linesHeight, linesHeight+ (h - lastLine.height));
		lastLine.height = Math.max(lastLine.height, h);
	}

	/*private TAbstractCell addCell(InfoP info, TAbstractCell c)
	{
		info.currentCell = info.cell.addCell(c);
		return c;
	}*/
	
	
	/** */
	private void wrapGetNextWord(String text, int w, Range r, int end, IGC gc) 
	{
		//int rs = r.start;
		
		String qs = text.substring(r.start, end);
		int wt = gc.textExtent(qs).getW();
		if (wt <= w)
		{
			r.end = wt;
			r.start = end; 
		}
		else
		{
			int pos = ((w * qs.length()) / wt);
			for (int i=pos; i > 0; i = i -1)
			{
				char c = qs.charAt(i);
				if ((Character.getType(c)!=Character.SPACE_SEPARATOR)
					&& (Character.getType(c)!=Character.END_PUNCTUATION)
                    && (Character.getType(c)!=Character.OTHER_PUNCTUATION))
                {
	                continue;
                }
				
//				if (!Character.isSpaceChar(c)						
//						&& (c!='.') && (c!=';') && (c!=',') && (c!='?')
//						&& (c!=':') && (c!='(') && (c!=')') && (c!='/')
//						&& (c!='[') && (c!=']') && (c!='\\'))

				wt = gc.textExtent(qs.substring(0, i+1)).getW();
				if ((wt <= w) || (i==1))
				{
					r.end = wt;
					r.start = r.start + i + 1;
					return;
				}
			}
			// on est pas arrive a decouper la chaine sur des separateurs
			// on va decouper les mots par dicotomie
			int a = qs.length() / 2;
			int b = qs.length();
			while (b-a>1)
			{
				String s = qs.substring(0, a+1);
				wt = gc.textExtent(s).getW();
				if (wt <= w)
				{
					a = a + (b-a)/2;
				}
				else
				{
					b = a;
					a = a / 2;
				}
			}
			
			// protection against infinite loop 
			if (a==0) 
			{
				wt = gc.textExtent(qs.substring(0, 1)).getW();
				a=1;
			} 
			
			r.end = wt;
			r.start = a + r.start;
		}
	}
	
	
	/**	 */
	private TCellText wrapPourTextBuffer(TCellText currentCell, IDItem item, String text, Range r, IGC gc, int hintW) 
	{
		
		if (text.length() == 0) return currentCell;
		
		//int w, wprev;
		int count = r.end - r.start;
		
		IFontMetrics fm = gc.getFontMetrics();
		int lineSpacing = fm.getHeight();
		
		// rien a traiter
		if (r.start >= r.end)
		{
			if ((r.start==0) && (text.getBytes()[r.start] == '\n'))
			{
				currentCell.setSize(0,lineSpacing);
				currentCell.setLen(0);
				addCellInLine(currentCell);
			}
			else
			{	
				addCarriageReturn(fm.getHeight());
			}
			return currentCell;
		}
		
		String qs = text.substring(r.start, r.end);	
		ISize p = gc.textExtent(qs);
		
		// Si on est en non WORD WRAP ou que le buffer rentre
		// dans la ligne alors on ajoute ce dernier
		// sur la ligne courante
		if (((getAlignment() & DParagraph.NO_WORD_WRAP)!=0) 
		|| (lastLine.width + p.getW() <= hintW)
		|| (hintW == ILayout.NO_SIZE_HINT))
		{			
			if (r.start==0)
			{
				currentCell.setText(text, r.start, count, fm.getDescent());
				currentCell.setSize(p.getW(), p.getH());
			}
			else
			{
				//TCellText ct = new TCellText(item, currentCell.getParent(),currentCell);
			    TCellText ct = new TCellText(item);
				currentCell.getParent().insertCell(ct, currentCell);
				ct.setText(text, r.start, count, fm.getDescent());
				ct.setSize(p.getW(), p.getH());
				
				currentCell = ct;
			}	
			addCellInLine(currentCell);
			return currentCell;
		}
		
		// sinon on va couper le buffer sur un separateur de mot afin
		// de la faire rentrer sur plusieurs lignes
		//wprev = 0;
		
		Range r2 = new Range();
		r2.start = r.start; // position dernier caractere de la sous chaine

		while (r2.start < r.end)
		{
			r2.end = 0;   // taille en pixel de la sous chaine
			
			wrapGetNextWord(text, hintW - lastLine.width, r2, r.end, gc);
			
			count = r2.start - r.start;
			
			if (r.start==0)
			{
				currentCell.setText(currentCell.getText(), r.start, count,gc.getFontMetrics().getDescent());
				currentCell.setSize(p.getW(), p.getH());
				currentCell.setSize(r2.end, lineSpacing);
			}
			else
			{
				//TCellText ct = new TCellText(item, currentCell.getParent(),currentCell);
				TCellText ct = new TCellText(item); //, currentCell.getParent(),currentCell);
				currentCell.getParent().insertCell(ct, currentCell);
				ct.setText(text, r.start, count, gc.getFontMetrics().getDescent());
				ct.setSize(r2.end, lineSpacing);
				
				currentCell = ct;
			}	
			
			addCellInLine(currentCell);
			
			r.start = r2.start;
			
			if (r2.start < r.end)
				newLine();
		}
		
		return currentCell;
	
	}
	
	private TCellText wrapTextBuffer(TCellText currentCell, String text, IDItem t, int hintW, IGC gc, float zoom)
	{
		// removes all another cell which point on the same
		// text because they will be recomputed
		TAbstractCell c = currentCell.getNext();
		TAbstractCell n = c;
		while ((c!=null)&&(c.getItem()==t))
		{	
			n = c.getNext();
			c.getParent().removeCell(c);
			//c.detach();
			c=n;
		}
		
		
		if (text==null) return currentCell;
		
		IFont oldFont = gc.getFont();
		IFont sfont = IGCDStyle.GetFont(t, zoom);
		gc.setFont(sfont);
	
		
		Range r = new Range();
		r.start = 0;
		r.end = text.indexOf("\n");
		
		// tant que l'on a pas atteint la fin de la ligne
		while (r.end != -1)
		{
			currentCell = wrapPourTextBuffer(currentCell, t, text, r, gc, hintW);
			
			
			// ligne non adaptative car terminee par \n
			// on ajoute donc une nouvelle ligne
			newLine();
			
			r.start = r.end + 1;
			
			// recherche du \n suivant 
			r.end = text.indexOf("\n", r.start);			 		
		}
		
		if (r.start < text.length())
		{
			r.end = text.length();
			currentCell = wrapPourTextBuffer(currentCell, t, text, r, gc, hintW);
		}
		
		gc.setFont(oldFont);
		//sfont.dispose();
		
		return currentCell;
	}

	
	
	/** 
	 * Computes the children cells for the IDItem 
	 * Calls TLayoutExtensible's doMethod  to fill the layout 
	 * 
	 * @see TLayoutExtensible */ 
	public void fillContent(TAbstractCellContainer _cell, IDItem _item, IGC _gc,
			                IDIImageProvider _pm, IDProgressMonitor monitor,
			                DTitleLevel tl, DListLevel ll, boolean flatpopup)
	{
		if ((_cell==null)||(_item==null)) throw new Error("TParagraphLayout: cell or item value null not expected");
		
		_cell.dispose();

		_cell.setItem(_item);

		InfoP d = new InfoP();
		d.cell          = _cell;
		d.gc            = _gc;
		d.imageProvider = _pm;
		d.alignment     = getAlignment();
		d.listLevel     = ll;
		d.titleLevel    = tl;
		d.flatpopup     = flatpopup;
		d.pm            = monitor;
		
		TExtensibleContentProvider.getInstance().doChildrenItem(_item, TExtensibleContentProvider.getInstance(), d);				
	}
	
	/**
	 * Computes the size of the paragraph. Each line width is lower than hintW if hintW is bigger than
	 * line width minimum.
	 * Automatic carriage return is inserted behind and after a DLine, DParagraph, DPopup, DTable, DPopup item. 
	 */
	public void computeSize(TAbstractCellContainer cell, int hintW, int hintH, float _zoom, IGC _gc, IDProgressMonitor monitor)
	{
		// if it is not necessary to resize the text
		if ((hintW==cell.getWidth())&& (hintH>=cell.getHeight()) && (zoom==_zoom))
	    {
		   	cell.setSize(hintW, hintH);
		   	return;
		}
		
		//sets the zoom
        zoom = _zoom;
        
        int hintW_new = ILayout.NO_SIZE_HINT;
        if (hintW!=ILayout.NO_SIZE_HINT)
            hintW_new  = hintW - (int)((getLeftMargin()+getRightMargin())*zoom);
        
        int hintH_new = ILayout.NO_SIZE_HINT;
        if (hintH!=ILayout.NO_SIZE_HINT)
            hintH_new = hintH - (int)((getTopMargin()+getBottomMargin())*zoom);
        
		firstLine = null;
		lastLine = null;
		linesHeight = 0;
		maxLineWidth = ILayout.NO_SIZE_HINT;
		newLine();

        // compute the real width
		boolean allfixed = true;
		
		
		monitor.setTotalWorks(monitor.getTotalWorks()+cell.getChildCount());
		
		for (TAbstractCell c = cell.getChild(); c!=null; c=c.getNext())
		{			    
			//TAbstractCell ccell = c;
			int w = (hintW_new==ILayout.NO_SIZE_HINT) ? hintW_new : Math.max(hintW_new, maxLineWidth);
			
			if (c instanceof TCellLinePrefix)
			{
			   newLine();	
			   w -= (int)((((TCellLinePrefix)c).getLevel())*5 + 3)*zoom;
			}
			else
			if ( (c.getItem() instanceof DLine)
				|| ((c.getItem() instanceof DParagraph && (!(c.getItem().getParent() instanceof DList))))
				|| (c.getItem() instanceof DPopup)
				|| (c.getItem() instanceof DTable))
			{
				newLine();
			}
			else
			if (c instanceof ICarriageReturn)
			{
			    if (((ICarriageReturn)c).hasCRBefore()) newLine();
			}
			else
			if (c.getItem() instanceof DTitle)
			{
				newLineSpacing(5);
			}
			
			if (c instanceof TMLayoutContentCellContainer)
			{
			    if (!((TMLayoutContentCellContainer)c).isFixedSize() && allfixed) 
			    	   allfixed = false;
			}
			else
				allfixed = DAlignment.HaveAlignment(getAlignment(), DParagraph.NO_WORD_WRAP);
			
			if (!(c instanceof TCellText))
			{	
			    c.computeSize(w - lastLine.width, ILayout.NO_SIZE_HINT, zoom, _gc, monitor);
			    
			    if ((c.getWidth() + lastLine.width <= w)
			        || (DAlignment.HaveAlignment(getAlignment(), DParagraph.NO_WORD_WRAP)))
			    {
				    addCellInLine(c);
			    }
			    else
			    {
				    newLine();
				    addCellInLine(c);
			    }
			    
			    if ((c.getItem() instanceof DLine)
			         || (c.getItem() instanceof DParagraph)
					 || (c.getItem() instanceof DTable))
			    {
				   newLine();
			    }
			    else
			    if (c instanceof ICarriageReturn)
			    {
			        if (((ICarriageReturn)c).hasCRAfter()) newLine();
			    }
		    }
			else
			{
				c = wrapTextBuffer((TCellText)c, ((TCellText)c).getText(), c.getItem(), w, _gc, zoom);
			}
			
			monitor.worked(monitor.getWorkCount()+1);
		}
		
		setFixedSize(allfixed);
		
		
		int retx=0;
		int rety=0;
		if (getMaxLineWidth() < hintW_new)
			retx = hintW_new + (int)((getLeftMargin()+getRightMargin())*zoom);
		else
			retx = getMaxLineWidth() + (int)((getLeftMargin()+getRightMargin())*zoom);
		
		if (getLinesHeight() < hintH_new)
			rety = hintH_new + (int)((getTopMargin()+getBottomMargin())*zoom);
		else
			rety = getLinesHeight() + (int)((getTopMargin()+getBottomMargin())*zoom);
				
		cell.setSize(retx, rety);
    }
	
	/**
	 * Sets the position X,Y of each children cell of the paragraph.
	 */
	public int layout(TAbstractCellContainer cell, float zoom, int charpos, IDProgressMonitor monitor)
	{	
		int align = getAlignment();
		int position = charpos;
		
		if (isReversed())
		{
			if ((align & DParagraph.LEFT)!=0)
				align = DParagraph.RIGHT;
			else
			if ((align & DParagraph.RIGHT)!=0)
				align = DParagraph.LEFT;
		}
		
		// compute lines height
		int height = linesHeight;
		 
		int currentY=getTopMargin();
		if ((align & DParagraph.VCENTER)!=0)
			currentY = (cell.getHeight() - height)/2;
		else
		if ((align & DParagraph.TOP)!=0)
			currentY = (int)(getTopMargin()*zoom);
		else
		if ((align & DParagraph.BOTTOM)!=0)
			currentY = cell.getHeight()-(int)(getBottomMargin()*zoom)-height;
		
		monitor.setTotalWorks(monitor.getTotalWorks()+cell.getChildCount());
		
		for (Line l=firstLine; l!=null;l = l.next)
		{
			int currentX=0;
			
			if ((align & DParagraph.LEFT)!=0)
				currentX = (int)(getLeftMargin()*zoom);
			else
			if ((align & DParagraph.RIGHT)!=0)
				currentX = cell.getWidth() - l.width - (int)(getRightMargin()*zoom);
			else
			if ((align & DParagraph.HCENTER)!=0)
				currentX = (cell.getWidth() - l.width)/2; 
			
			TAbstractCell c = l.first;
			int maxDsc=0;
			int maxTextH=0;
			while (c!=null)
			{
			    if (c instanceof TCellText)
			    {
			        if (((TCellText)c).getText()!=null)
			           maxTextH=Math.max(maxTextH, c.getHeight());
			        maxDsc = Math.max(maxDsc, ((TCellText)c).getDescent()); 
			    }
			   	if (c == l.last) break;
			   	c = c.getNext();
			}
			

			c = isReversed() ? l.last : l.first;
			TAbstractCell last = isReversed() ? l.first : l.last;
			
			while (c!=null)
			{	
				int yoffset = 0;
				
				if (c instanceof TCellText)
				{
				    TCellText ct = (TCellText)c;
				
				    if (ct.getDescent()==0)
				    {	
					   if (DAlignment.HaveAlignment( align, IDAlignment.VCENTER) )
					   {
						  yoffset = (l.height - c.getHeight())/2;             
					   }
					   else if (DAlignment.HaveAlignment( align, IDAlignment.BOTTOM) )
					   {     
						  yoffset = l.height - c.getHeight();              
					   }
				    }
				    else
				    {	
				
				       if (DAlignment.HaveAlignment( getAlignment(), IDAlignment.VCENTER) )
				       {
						  yoffset = l.height/2 - maxTextH/2 + maxTextH - maxDsc + ct.getDescent() - c.getHeight();           
				       }
				       else if (DAlignment.HaveAlignment( getAlignment(), IDAlignment.BOTTOM) )
				       {      
						  yoffset = l.height - maxDsc + ct.getDescent() - c.getHeight();            
				       }
				       else // TOP
				       {
						  yoffset = -maxDsc+ ct.getDescent() + maxTextH - c.getHeight();
				       }
				    }
					
				}  
				

				if ((c instanceof TCellLinePrefix) && (DAlignment.HaveAlignment(align, DParagraph.LEFT)))
				{	
					TCellLinePrefix le = (TCellLinePrefix)c;
					currentX += (int)((le.getLevel())*5*zoom);
				}
				
				c.setPosition(position);
				c.setXY(currentX, currentY + yoffset);
				
				if (c instanceof TAbstractCellContainer)
				    position = ((TAbstractCellContainer)c).layout(zoom, position, monitor);
				else
				if (c instanceof TCellText)
					position += ((TCellText)c).getLen();
				
				currentX += c.getWidth();
				
				if ((c instanceof TCellLinePrefix) && (DAlignment.HaveAlignment(align, DParagraph.LEFT))
					|| (c.getItem() instanceof DTitle))
				{
					currentX += (int)(3*zoom);
				}
				
				if (c == last) break;
				c = isReversed() ? c.getPrevious() : c.getNext();
				
				monitor.worked(monitor.getWorkCount()+1);
			}
				
			currentY += l.height;
		}
		
		return position;
				
	}

	/**
	 * Builds a new paragraph layout with an initial alignment and a parent layout.
	 * This layout inherits inverse and ??? attribute values of the parent.
	 */
	 public TCellParagraph(IDItem i, ILayout parent, int align )
	 {
	    super(i);
	 	setAlignment(align);
	 	
	 	if (parent==null) return;
	 	setReversed(parent.isReversed());
	 }
	 
	 
	/**
	 * Returns the max line width.
	 */
	public  int getMaxLineWidth()
	{
		return maxLineWidth;
	}

	/**
	 * Returns the height in pixel of all lines.
	 */
	public  int getLinesHeight()
	{
		return linesHeight;
	}
	
	/**
	 * Returns tne number of line.
	 */
	public  int getLineCount()
	{
		int i=0;
		for (ILine l=getFirstLine();l!=null;l=l.getNext()) i++;
		return i;
	}
	
	/**
	 * Returns the line at the position i.
	 */
	public  ILine getLineAt(int i)
	{
		int n=0;
		for (ILine l=getFirstLine();l!=null;l=l.getNext()) 
		{
			if (i<n) continue;
			return l;
		}
		return null;
	}
	
	/**
	 * Returns the first line.
	 */
	public ILine getFirstLine()
	{
		return firstLine;
	}
	
	/**
	 * Returns the last line.
	 */
	public ILine getLastLine()
	{
		return lastLine;
	}
	
	
    /**
	 * Returns the alignment.
	 * @see IDAlignment
	 */
	public int getAlignment() {
		   return alignment;
	}

	/**
	 * Sets the alignment of the layout
	 * @see IDAlignment
	 */
	public void setAlignment(int alignment) {
		   this.alignment = alignment;
	}

	
}