/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellRenderable.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/*
 * Created on 25 mars 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDRenderable;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;


/**
 * @author emiravet
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class TCellRenderable extends TCellData {

		
	public TCellRenderable(IDRenderable i)
	{
		super(i);
	}
	
	public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor)
	{
		int w = hintW;
		int h = hintW;
		
		if (getItem() instanceof DGraphic)
		{
	      DGraphic g = (DGraphic)getItem();
			
		  w = (int)((float)hintW * g.getWidthScale());
		  h = (int)((float)hintW * g.getHeightScale());
		
		  int max_w = g.getProperties().get( DGraphic.P_MAX_WIDTH, w );
		  int min_w = g.getProperties().get( DGraphic.P_MIN_WIDTH, w );
		  int max_h = g.getProperties().get( DGraphic.P_MAX_HEIGHT, h );
		  int min_h = g.getProperties().get( DGraphic.P_MIN_HEIGHT, h );
		
		  if( w < min_w ) w=min_w; else if ( w > max_w ) w = max_w ;
		  if( h < min_h ) h=min_h; else if ( h > max_h ) h = max_h ;

		  if( !g.getProperties().hasKey( DGraphic.P_MIN_WIDTH  )
				&& !g.getProperties().hasKey( DGraphic.P_MAX_WIDTH  )
				&& !g.getProperties().hasKey( DGraphic.P_MIN_HEIGHT )
				&& !g.getProperties().hasKey( DGraphic.P_MAX_HEIGHT )
		  )
		  {
			float ratio = g.getWidthScale()/g.getHeightScale();
			if (ratio <= 1.0f)
			{
				min_w = (int)(200 * zoom);
				if (w < min_w)
				{
					w = min_w;
					h = (int)(w/ratio);
				}
				else
				{
					min_h =  (int)(200 * zoom);
					if (h < min_h)
					{
						h = min_h;
						w = (int)(h*ratio);
					}
				}
			}
		  }
		}
		else
		{
			IDRenderable r = (IDRenderable)getItem();
			
			w = (int)((float)hintW * r.getWidthScale());
			h = (int)((float)hintW * r.getHeightScale());
		}
					
		setSize(w, h);
	}
}