/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellTable.java,v 1.3 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

/*
 * Created on 19 fvr. 2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


//import org.eclipse.swt.graphics.Point;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;




/**
 * Provides a layout which manages each children as cell of a table
 *
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class TCellTable extends TMLayoutContentCellContainer
{
    TMLayoutContentCellContainer[][] items;
	
	int   nbCol;
	int   nbRow;
	int   border;

	
	float[] columnWidth = null;
	
	private int[] maxC = new int [nbCol];

	
	private class Info implements TExtensibleContentProvider.IArg {
		
		TAbstractCellContainer cell;
		TAbstractCell          currentCell;
		IGC              gc;
		IDIImageProvider  imageProvider;
		IDProgressMonitor pm;
		int             hintW;
		int             hintH;
		float           zoom;
		DListLevel      listLevel;
		DTitleLevel     titleLevel;
		boolean         flatPopup;
		
		int             rowSpans[];
		int             nuRow;
		int             nuCol;
		
		public IGC              getGc()            { return gc; }
		public IDIImageProvider  getImageProvider() { return imageProvider; }
		public DListLevel      getListLevel()     { return listLevel; }
		public DTitleLevel     getTitleLevel()    { return titleLevel; }
		
		public boolean         isDrawPopup()      { return false; }
		public boolean         isFlatPopup()      { return flatPopup; }
		public void            setDrawPopup(boolean v) {}
		
		public TAbstractCellContainer getContainer()     { return cell; }
		public TAbstractCell          getCell()          { return currentCell; }
		public ILayout         getLayout()        { return TCellTable.this; }
        public IDProgressMonitor getProgressMonitor() { return pm; }
		
		
		public void addReturnValue(TAbstractCell c)
		{
		    if (!(c instanceof TMLayoutContentCellContainer)) return;
		    
			if (!(c.getItem() instanceof DCell)) return;
			DCell ci = (DCell)c.getItem();
			
			if (nuRow>0 && (c.getItem() instanceof DCell))
			{	
				for (int i=nuCol; i<nbCol; i++)
				{
					if (rowSpans[nuCol]>0) 
					{rowSpans[nuCol]--; nuCol++; }
					else
						break;
				}
			}
			
			cell.addCell(c);
			items[nuRow][nuCol] = (TMLayoutContentCellContainer)c;
			
			rowSpans[nuCol] = ci.getRowSpan();
			nuCol += 1 + ci.getColSpan();
			
			if (ci.getNext()==null) // row++
			{
				nuCol=0;
				nuRow++;
			}
		}
       
	}
	
	
	/**
	 * Builds a table layout with row rows and col columns.  
	 * @param row is the number of rows.
	 * @param col is the number of columns.
	 * @param _columnWidth is a percent factor table of each column size.
	 * @param _border is the size of cell border (0 = no border)
	 */
    public TCellTable(IDItem i, int row, int col,  float[] _columnWidth, int _border)
	{
        super(i);
    	items = new TMLayoutContentCellContainer[row][col];
    	columnWidth = _columnWidth;
    	nbCol = col;
    	nbRow = row;
    	border = _border;
    }
   
    
    /**
     * Fills the content of the table layout. 
     * This method calls the TLayoutExtensible's doMethods.
     * @see TLayoutExtensible
     */
    public void fillContent(TAbstractCellContainer cell, IDItem item,  IGC _gc, IDIImageProvider _pm , 
                            IDProgressMonitor monitor,
    		                DTitleLevel tl, DListLevel ll, boolean flatpopup)
	{
    	Info d = new Info();
    	d.cell = cell;
    	d.gc = _gc;
    	d.imageProvider = _pm;
    	d.rowSpans = new int[nbCol];
    	d.nuRow = 0;
    	d.nuCol = 0;
    	d.listLevel = ll;
    	d.titleLevel = tl;
    	d.flatPopup = flatpopup;
    	d.pm = monitor;
    	
    	TExtensibleContentProvider.getInstance().doChildrenItem(item, TExtensibleContentProvider.getInstance(), d);				
    }
    
    /**
     * Computes the size of the table
     */
    public void computeSize(TAbstractCellContainer cell, int hintW, int hintH, float zoom, IGC _gc,
                            IDProgressMonitor monitor)
	{
    	if (items==null) return;
    	if (nbRow==0) return;
    	
    	setSpacing((int)(getBorder()*zoom));
    	
    	int[] hintWs = new int[items[nbRow-1].length];
    	
    	int w = (int)(hintW) - (int)(getSpacing()*(nbCol+1));
        int r = w;
               
    	for (int i=0; i< hintWs.length-1; i++)
    	{
    		if ((columnWidth!=null) && (i <columnWidth.length))
    			hintWs[i] = (int)(w * columnWidth[i]);
    		else
    			hintWs[i] = (int)(w / nbCol);
    		r -= hintWs[i];
    	}

    	if ((columnWidth!=null) && (columnWidth.length > hintWs.length-1))
    	    hintWs[hintWs.length-1]=(int)(w*columnWidth[hintWs.length-1]);
        else
        	hintWs[hintWs.length-1]=r;
        
    	// compute each cell size and store max for each col and row

    	int[] maxR = new int [nbRow];
    	maxC = new int [nbCol];
    	
    	setFixedSize(true);
    	
    	boolean[] sizeable = new boolean[nbCol];
    	
    	
    	
    	int m = (int)(2*zoom);
        for (int i=0; i< nbRow; i++)
        {
        	//int maxW=0;
        	for (int j=0; j<nbCol; j++)
        	{
        		TMLayoutContentCellContainer c = items[i][j];
        		if (c==null) {continue; }
        		
        		c.setMargin(m,m,m,m);
        		
        		DCell cli = (DCell)c.getItem();
        		
        		int s=hintWs[j];
        		for (int k=0;k<cli.getColSpan() && (j+k+1<nbCol);k++)
        			s+=hintWs[j+k+1];
        		
        		c.computeSize(s, ILayout.NO_SIZE_HINT, zoom, _gc, monitor);
        		
        		sizeable[j]=!(c.getWidth() > s);
        			
        		// the size of cell isn't computed for cell with RowSpan or ColSpan
        		if (cli.getColSpan()==0)
        			maxC[j] = Math.max(c.getWidth(), maxC[j]);
        		
        		if (cli.getRowSpan()==0)
        			maxR[i] = Math.max(c.getHeight(), maxR[i]);
        		
        		
        	}
        	
        	for (int k=0; k<nbCol; k++)
        	{
        		//Point pt;
        		TAbstractCell c = items[i][k];
        		if (c==null) continue;
        		
        		DCell cli = (DCell)c.getItem();
        		
        		if (cli.getRowSpan()>0)
        		{	
        		   int r2 =0;
        		   for (int l=0; l<cli.getRowSpan() && (i+l<nbRow);l++) r2+=maxR[i+l];
        		   int nurow = i+cli.getRowSpan()<nbRow?i+cli.getRowSpan():nbRow-1;
        		   maxR[nurow] = Math.max(maxR[nurow],c.getHeight()-r2);
        		}
        	}
        }
        
        int nbs=0;
        int wt=0;
        for (int j=0; j<nbCol; j++) { if (sizeable[j]) nbs++; wt += maxC[j]; }
        if (nbs<nbCol)
        {
        	for (int j=0; j<nbCol; j++)
        	{
        		if (sizeable[j])
        			maxC[j] -= (int)((wt-w)/nbs);
        	}
        }
        
        
        // resize each cell with correct value
        monitor.setTotalWorks(monitor.getTotalWorks()+(nbCol*nbRow));
        for (int i=0; i<nbRow; i++)
        {
        	for (int j=0; j<nbCol; j++)
        	{
        		TMLayoutContentCellContainer c = items[i][j];
        		if (c==null) {monitor.worked(monitor.getWorkCount()+1); continue;}
        		
        		DCell cli = (DCell)c.getItem();
        		
        		int wcell = maxC[j];
        		int hcell = maxR[i];
        		
        		for (int k=0; k<cli.getColSpan() && (k+j+1<nbCol); k++)
        			wcell += maxC[k+j+1]+(int)(getSpacing()*zoom);
        		
        		for (int l=0; l<cli.getRowSpan() && (l+i+1<nbRow); l++)
        			hcell += maxR[l+i+1]+(int)(getSpacing()*zoom);
        		
        		c.computeSize(wcell, hcell, zoom, _gc, monitor);
        		
        		if (!c.isFixedSize()) setFixedSize(false);
        		
        		monitor.worked(monitor.getWorkCount()+1);
        	}
        }
        
        // compute the size of the table
        int retx=0;
        int rety=0;
        for (int i=0;i<nbCol;i++)
        	retx += maxC[i];
        for (int i=0;i<nbRow;i++)
        	rety += maxR[i];
        retx +=  (int)(getSpacing()*zoom)*(nbCol+1);
        rety +=  (int)(getSpacing()*zoom)*(nbRow+1);

        cell.setSize(retx, rety);
    }
    
    /**
     * Sets the XY coordinate positions of each cell.
     */
    public int layout(TAbstractCellContainer cell, float zoom, int charpos, IDProgressMonitor monitor)
	{
		boolean r = isReversed();
		
		int z_spacing = (int)Math.round( getSpacing()*zoom );
		int currentY = z_spacing;
		int pos = charpos;
		
		monitor.setTotalWorks(monitor.getTotalWorks()+(nbCol*nbRow));
    	for (int i=0; i<nbRow; i++)
    	{
    		int h = 0;
    		int currentX = r ? (cell.getWidth()) /*- (int)(getSpacing()*zoom))*/: z_spacing;
		
    		for (int j=0; j<nbCol; j++ )
    		{
    			TMLayoutContentCellContainer c = items[i][j];
    			
    			int dec = maxC[j] + 1;
    			
    			// add the width of the column for the null cell (colspan)
    			while (j+1<nbCol && items[i][j+1]==null)
    			{
    			    j++;
    			    dec += maxC[j] + 1;
    			}
    			monitor.worked(monitor.getWorkCount()+1);
    			
    			if (j==nbCol) continue;
    			
    			// if it is a null cell update X coord and continue
    			if (c==null)
    			{
    			    currentX += (r ? -dec: dec);
    			    continue;
    			}
    			
    			pos = c.layout(zoom, pos, monitor);
    			if( r ) currentX -= dec;
    			c.setXY( currentX , currentY);
    			if( !r ) currentX += dec ;
    			h = c.getHeight();
    		}
    		currentY += h + z_spacing ;
    	}
    	
    	return pos;
    }
    
	/**
	 * Returns the percent factor table for column size.
	 */
	public float[] getColumnWidth() {
		return columnWidth;
	}

	/**
	 * Sets the percent factor table for column size.
	 */
	public void setColumnWidth(float[] columnWidth) {
		this.columnWidth = columnWidth;
	}
	

	/**
	 * Returns the border size.
	 */
	public int getBorder() {
		return border;
	}

	/**
	 * Sets the border size.
	 */
	public void setBorder(int border) {
		this.border = border;
	}
	
}
