/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TCellText.java,v 1.2 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 1 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;


import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;


/**
 * Provides a cell to support string character. It is generally mapped on DText item
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class TCellText extends TAbstractCell
{
	protected String text;
	protected int start;
	protected int len;
	protected int descent;
    
	/** Builds a new cell text on the item i with the text t. The text start
	 * at the start character position, on len character. 
	 * The descent is the value of the font descent attribut. It is necessary
	 * the computes the height and position of the cell.
	 * @see TCellParagraph#layout
	 */
	public TCellText(IDItem i, String t) //, int start, int len, int descent)
	{
		super (i);
		setText(t, 0, t.length(), 0); //start, len, descent); 
	}
	
	/**
	 * Computes the size of the cell text
	 */
	public void computeSize(int hintW, int hintH, float zoom, IGC gc, IDProgressMonitor monitor)
	{
		if (getText()==null) return;
		
		IFont sfont = IGCDStyle.GetFont( getItem(), zoom );
		IFont oldFont = gc.setFont(sfont);
		
		String qs = getText().substring(start, start+len);	
		ISize p = gc.textExtent(qs);
		
		gc.setFont(oldFont);
		
		setSize(p.getW(), p.getH());
	}
	
	/**
	 * Returns the string character pointed by the cell
	 */
	public String getText()
	{
		return text;
	}
	
	/**
	 * Returns always true
	 */
	public boolean isText()
	{
		return true;
	}
	
	/**
	 * Creates a new cell on the item i
	 */
	public TCellText(IDItem i)
	{
	   super(i);
	}
	
	/**
	 * Returns the text lenght mapped by the cell. 
	 */
	public int getLen() 
	{
		 return len;    
	}
	
	public int getStart() 
	{
		 return start;    
	}
	
	public void setStart(int s) 
	{
		start = s;    
    }
   
	public void setLen(int aLen) 
	{
		 len = aLen;    
	}
	
	public void setText(String s, int st, int l, int dsc) 
	{
	   text = s;
	   start = st;
	   len = l;    
	   descent = dsc;
	}
	
	public void setText(String s)
    {
	   text    = s;
	   start   = 0;
	   len     = text.length();
	   descent = 0;
	}
	
	
	public void clear()
	{
		text = null;
		start = 0;
		len = 0;
		position = 0;
		descent = 0;
	}
	/**
	 * @return Returns the descent.
	 */
	public int getDescent() {
		return descent;
	}

	/**
	 * @param descent The descent to set.
	 */
	public void setDescent(int descent) {
		this.descent = descent;
	}
	
	/** returns the cell where the position pos is contained */
	public TAbstractCell mapPositionToCell(int pos)
	{
		  if ((getPosition() <= pos) && (pos <= getPosition() + getLen())) 
		     return this;
		  else
		      return null;
	}

    /**
     * @see org.eclipse.tptp.platform.report.drivers.ui.layout.internal.TAbstractCell#dump(int)
     */
    public void dump(int level) 
    {
        for (int i=0; i<level; i = i + 1)
 		   System.out.print("  ");
 		   
 	    System.out.print("<cell x=\"" + getX() + "\" y=\"" + getY() 
 								+ "\" w=\"" + getWidth() + "\" h=\"" + getHeight()
 								+ "\"" );
 		
        TCellText ct = (TCellText)this;
 		System.out.print(" type=\"text\">");
 		String s = ct.getText();
 		if (s != null)
 		    System.out.print(s.substring(ct.getStart(), ct.getStart()+ct.getLen()));
 		
 		System.out.println("</cell>");   
    }
}
