/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TExtensibleContentProvider.java,v 1.4 2008/05/23 14:12:18 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/

package org.eclipse.tptp.platform.report.drivers.ui.layout.internal;

import org.eclipse.tptp.platform.report.core.internal.*;
import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.tools.internal.DChartTranslator;
import org.eclipse.tptp.platform.report.tools.internal.DLinkResolver;
import org.eclipse.tptp.platform.report.tools.internal.DListLevel;
import org.eclipse.tptp.platform.report.tools.internal.DParser;
import org.eclipse.tptp.platform.report.tools.internal.DTitleLevel;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;



/**
 * This object provides an extender to the fillContent method of IContentProvider.
 * This object is allocated once.
 * This object defines a doMethod for each JScrib items. 
 * The third parameter of doMethod in an object that implements the
 * TLayoutExtensible.IArg interface.
 * 
 * @see DExtensible
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 */
public class TExtensibleContentProvider extends DParser  {
	
	/**
	 * The object passed in argument of doMethod implement this
	 * interface.
	 */
	public static interface IArg 
	{	
		/** returns the current layout */
		ILayout          getLayout();
		
		/** returns the container cell associated with the layout */
		TAbstractCellContainer  getContainer();
		
		/** returns the current cell */
	    TAbstractCell           getCell();
		
		/** returns the title level object */
		DTitleLevel      getTitleLevel();
		
		/** returns the list level object */
		DListLevel       getListLevel();
		
		/** returns true if the flat popup mode is activated */
		boolean          isFlatPopup();
		
		/** returns true if the draw popup mode is activated */
		boolean          isDrawPopup();
		
		/** de/activates the draw popup mode */
		void             setDrawPopup(boolean v);
	
		/** @return the current GC */
		IGC               getGc();	
		
		/** @return the image provider */
		IDIImageProvider   getImageProvider();
		
		/** @return the progress monitor */
		IDProgressMonitor getProgressMonitor();
		
		/** adds a cell in the container cell and the current layout */
		void             addReturnValue(TAbstractCell arg);           		
	}
	
	private static TExtensibleContentProvider globalLayoutExtensible = null; 
	
	static public TExtensibleContentProvider getInstance() {
		if (globalLayoutExtensible==null)
			globalLayoutExtensible = new TExtensibleContentProvider();
		return globalLayoutExtensible;
			
	}
	
	private TExtensibleContentProvider()
	{}
	
	
	/** Adds a prefix for each item that can be a new list item 
	 *   DParagraph, DImage, DTextualItem, DLink
	 */
	public TAbstractCell addListItemPrefix(IArg info, IDItem i) 
	{  
		TAbstractCell c = null;
		if (!(i.getParent() instanceof DList)) return c;
		
		DList l = (DList)i.getParent();
		
		info.getListLevel().newEntry();
		
		switch (l.getFormat())
		{
		case DStyle.NOTHING:
			break;
			
		case DStyle.GLYPH:
			ISymbol s;	

			switch (info.getListLevel().getLevel())
			{
			case 1: s = DSymbolRegistry.GetOval(); break;
			case 2: s = DSymbolRegistry.GetSquare(); break;
			case 3: s = DSymbolRegistry.GetDiamond(); break;
			case 4: s = DSymbolRegistry.GetRight(); break;
			default:
				s = DSymbolRegistry.GetMinus(); break;     
			}
			
			info.addReturnValue(new TCellLinePrefix(l, s, i, info.getListLevel().getLevel()-1));
			break;
			
		default:
			String rval = info.getListLevel().toFormatString(l.getFormat());
			if (rval != null)
			{
				info.addReturnValue(new TCellLinePrefix(l, rval, i, info.getListLevel().getLevel()-1));
			}
			break;
			
		}
		return c;
	}

	
	/**	sets doc item to the container */
	public void doMethod(DDocument doc, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
		info.getContainer().setItem(doc);
		doChildrenItem(doc,ext,info);
	}
	
	
	
	/**	Adds a TCellGraphic to manage DGraphic item */
	public void doMethod(IDRenderable g, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
		TCellFocusMark fc = new TCellFocusMark(g);
		info.addReturnValue(fc);
			
		//data will be used create/modified by chart render.
        IDRenderable renderable = g;
        if (g instanceof DGraphic)
        {
            DChartTranslator tc = new DChartTranslator();
            renderable = tc.translate((DGraphic)g);
            //graph.insertChild(c, null);
        }
        
		TAbstractCell c = new TCellRenderable(renderable);
		info.addReturnValue(c);
				
		fc.setEndMark(c);
	}

	/** Adds a TCellImage by using the DImageProvider object passed in parameter arg */
	public void doMethod(DImage i, DExtensible ext, Object arg) 
	{ 
		IArg info = (IArg)arg;
	
		addListItemPrefix(info, i);
		
		IImage img = info.getImageProvider().getImage( i.getName() );
		info.addReturnValue(new TCellImage(i, img, 0, 0));
	}
	
	
	/** Increases the list level, calls doChildrenItem and decreases level
	 * before exiting 
	 * 
	 * @see DParser#doChildrenItem  */
	public void doMethod(DList l, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;	
		
		info.getListLevel().increase();
		doChildrenItem(l,ext,arg);
		info.getListLevel().decrease();
		
	}
	
	/** Adds a TCellLine */
	public void doMethod(DLine l, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
		info.addReturnValue(new TCellLine(l));
	}
	
	/** Adds a TCell */
	public void doMethod(DPageBreak pb, DExtensible ext, Object arg)
	{  
		IArg info = (IArg)arg;
		
		info.addReturnValue(new TCell(pb));
	}
	
	/** Adds a TCellText */
	public void doMethod(DPageCounter pc, DExtensible ext, Object arg) 
	{ 
		IArg info = (IArg)arg;
		
		info.addReturnValue(new TCellText(pc, "99999"));
	}
	
	/** Adds a TCellContainer with a TParagraphLayout and calls the container's fillContent method */
	public void doMethod(DParagraph p, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
		addListItemPrefix(info, p);
		
		TCellParagraph cp = new TCellParagraph(p, info.getLayout(), p.getAlignment());
		cp.fillContent(p, info.getGc(),  info.getImageProvider(), info.getProgressMonitor(),
				       info.getTitleLevel(), info.getListLevel(), info.isFlatPopup());
		info.addReturnValue(cp);
	}
	
	/** Adds a TCellContainer with a TParagraphLayout only if the draw popup mode
	 * is activated and calls the container's fillContent method*/
	public void doMethod(DPopup p, DExtensible ext, Object arg) 
	{	
		IArg info = (IArg)arg;
	
		if (info.isDrawPopup())
		{
			TCellParagraph c = new TCellParagraph(p, info.getLayout(), p.getAlignment());
			c.setMargin(5, 5, 5, 5);
			c.fillContent(p, info.getGc(),  info.getImageProvider(), info.getProgressMonitor(),
					      info.getTitleLevel(), info.getListLevel(), info.isFlatPopup());
			info.addReturnValue(c);
		}
	}
	
	/** Adds a TCellFocusMark, calls doChildrenItem and inserts the popup
	 * only if l is a popup link and the flat popup mode is activated */
	public void doMethod(DLink l, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
		addListItemPrefix(info,l);
		
		TCellFocusMark fc = new TCellFocusMark(l);
		info.addReturnValue(fc); 
			
		doChildrenItem(l,ext,arg);
			
		if (!(DLinkUtil.isPopupLink( l ) && info.isFlatPopup())) 
		{
			fc.setEndMark(info.getCell());	   	
			return;	   
		}  
			
		DLinkResolver r = new DLinkResolver(l);
		r.resolve(null);
		DPopup popup = (DPopup)r.getTaggedItem();
			
		if (popup!=null)
		{
			boolean dp = info.isDrawPopup();
			info.setDrawPopup(true);
			invokeDoMethod(popup, ext, arg);
			info.setDrawPopup(dp);
		}   
		
	}
	
	/** Adds a new TCell and calls doChildrenItem */
	public void doMethod(DSection s, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
		info.addReturnValue(new TCell(s));
		doChildrenItem(s,ext,info);
	}
	
	/** Adds a TCellContainer with a TTableLayout and calls the fillContent method of the
	 * container */
	public void doMethod(DTable t, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
		TCellTable l = new TCellTable(t, t.getRowCount(), 
					t.getColumnCount(), 
					t.getColumnWidth(), t.getBorder());
	    l.setReversed( info.getLayout().isReversed() );
	    
		l.fillContent(t, info.getGc(), info.getImageProvider(), info.getProgressMonitor(),
				      info.getTitleLevel(), info.getListLevel(), info.isFlatPopup());
		info.addReturnValue(l);
	}
	
	/**  Adds a TCellContainer with a TParagraphLayout and calls the fillContent method of the
	 * container */
	public void doMethod(DCell c, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
		TCellParagraph cl = new TCellParagraph(c, info.getLayout(), c.getAlignment());
		
		cl.fillContent(c, info.getGc(),  info.getImageProvider(), info.getProgressMonitor(),
				       info.getTitleLevel(), info.getListLevel(), info.isFlatPopup() );
		info.addReturnValue(cl);
	}
	
	
	/**  Adds a TCellContainer with a TParagraphLayout and adds a TCellText in the container */
	public void doMethod(DCellText c, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
 		TCellParagraph cl = new TCellParagraph(c, info.getLayout(), c.getAlignment());
			
		String s = c.getText()==null ? "": c.getText();
		
		cl.addCell(new TCellText(c, s));	
		info.addReturnValue(cl);		
	}
	
	/** Calls the doChildrenItem */
	public void doMethod(DRow r, DExtensible ext, Object arg) 
	{
		//IArg info = (IArg)arg;
		
		doChildrenItem(r, ext, arg);
	} 
	
	/** Adds a TCell */
	public void doMethod(DTag t, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
		info.addReturnValue(new TCell(t));
	}
	
	/** Adds a TCell */
	public void doMethod(DData d, DExtensible ext, Object arg)
	{
		IArg info = (IArg)arg;
		
		info.addReturnValue(new TCell(d));
	}
	
	
	/** Adds a TCellText */
	public void doMethod(IDTextualItem t, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
		addListItemPrefix(info, t);
		
		String text = t.getText();
		if (text==null) return;
		
		info.addReturnValue(new TCellText(t, text));
	}
	
	/**
	 * Increases the title level, adds TCellText to support title number and calls
	 * doChildrenItem
	 */
	public void doMethod(DTitle t, DExtensible ext, Object arg) 
	{
		IArg info = (IArg)arg;
		
		IDStyle s = t.getAppliedStyle();
		int format = DStyle.NUMBER;
		if (s != null)
			format = s.getNumberingFormat();
			
		info.getTitleLevel().increase(t.getLevel());
		String st = info.getTitleLevel().toFormatString(format);
			
		info.addReturnValue(new TCellText(t, st));
			
	    doChildrenItem(t,ext,arg);	
	}
		
	
	/** do nothing (not yet implemented) */
	public void doMethod(DSummary summary, DExtensible ext, Object arg)
	{
		//IArg info = (IArg)arg;		
	}
	
	/** do nothing (not yet implemented) */
	public void doMethod(DIndex index, DExtensible ext, Object arg)
	{
		//IArg info = (IArg)arg;
	}
	
	/** do nothing (not yet implemented) */
	public void doMethod(DIndexEntry indexentry, DExtensible ext, Object arg)
	{
		//IArg info = (IArg)arg;
		
		doChildrenItem(indexentry,ext,arg);
	}
	
	/** create TCellFolder for given DFolder */
	public void doMethod( DFolder _folder, DExtensible ext, Object arg )
	{
	  TExtensibleContentProvider.IArg info = (TExtensibleContentProvider.IArg)arg;
	  
	  ((TExtensibleContentProvider)ext).addListItemPrefix( info, _folder );
	  
	  TCellFolder cell = new TCellFolder( _folder );
      cell.getLayout().setReversed( info.getLayout().isReversed() );
      
	  cell.fillContent( cell, _folder, info.getGc(),  info.getImageProvider(), info.getProgressMonitor(),
	      info.getTitleLevel(), info.getListLevel(), info.isFlatPopup() );      
	  
	  info.addReturnValue( cell );
	}
	
	/** Create TCellBorder on a DBorder item */
   public void doMethod( DBorder _border, DExtensible ext, Object arg )
   {
      TExtensibleContentProvider.IArg info = (TExtensibleContentProvider.IArg)arg;
      
      ((TExtensibleContentProvider)ext).addListItemPrefix( info, _border );
      
      TCellBorder cell = new TCellBorder( _border );
      cell.getLayout().setReversed( info.getLayout().isReversed() );

      cell.fillContent( cell, _border, info.getGc(),  info.getImageProvider(), info.getProgressMonitor(),
				       info.getTitleLevel(), info.getListLevel(), info.isFlatPopup() );      

      info.addReturnValue( cell );
   }
   
   /** @see DParser#doChildrenItem(IDItem, DExtensible, Object) */
   public void doChildrenItem(IDItem item, DExtensible ext, Object parser_arg ) 
   {
     if ( item==null ) return ;
   
     TExtensibleContentProvider.IArg info = (TExtensibleContentProvider.IArg)parser_arg;
     
     info.getProgressMonitor().setTotalWorks(info.getProgressMonitor().getTotalWorks()
                                             + item.getChildCount());
     
	 for (IDItem i = item.getFirstChild(); i != null; i = i.getNext())
	 {
	   invokeDoMethod(i, ext, parser_arg);
	   info.getProgressMonitor().worked(info.getProgressMonitor().getWorkCount()+1);
	 }
   }
}
