/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JScribDialog.java,v 1.2 2008/05/23 14:12:20 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 19 janv. 2004
 *
*/
package org.eclipse.tptp.platform.report.ui.dialogs.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.report.ReportCorePlugin;
import org.eclipse.tptp.platform.report.signals.internal.Signal;

/**
 * This class provides a generic dialog with extended functionnalities. 
 * This class extends the SWT class Dialog
 * and adds two signals: 
 * <UL>
 * <LI>applied() when the button Ok/Apply is clicked
 * <LI>canceled() when the button Cancel is clicked
 * </UL>
 * Use this dialog like that:
 * <PRE>
 * ...
 * MyJScribDialog d = new MyJScribDialog(parent);
 * d.applied.connect(this,"acceptClicked()");
 * d.open();
 * ...
 * </PRE>
 * 
 * You can construct a dialog with particular flag values to configure the control buttons.
 * For example if you want to construct a dialog just with button Ok,Cancel:
 * <PRE>
 * MyJScribDialog d = new MyJScribDialog(parent, JSCRIB_OK_BUTTON|JSCRIB_CANCEL_BUTTON);
 * </PRE>
 * 
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 * 
 */
public class JScribDialog extends Dialog 
{
	/**
	 * Show the OK button
	 */
	public final static int JSCRIB_OK_BUTTON = 0x01;
	
	/**
	 * Show the Cancel button
	 */
	public final static int JSCRIB_CANCEL_BUTTON = 0x02;
	
	/**
	 * Show the Apply button
	 */
	public final static int JSCRIB_APPLY_BUTTON = 0x04;
	
	/**
	 * Show the Help button
	 */
	public final static int JSCRIB_HELP_BUTTON = 0x08;
	
	
	/**
	 * <b>Signal :</b> cancelPressed()
	 * <br>
	 * Emit when the user click on the cancel button of the dialog
	 */
	public Signal canceled = new Signal("canceled()"); //$NON-NLS-1$
	
	/**
	 * <b>Signal :</b> applyPressed()
	 * <br>
	 * Emit when the user click on the apply button of the dialog
	 */
	public Signal applied = new Signal("applied()"); //$NON-NLS-1$
	
	
    private int flag;
	
    /*
     * Constructs a Dialog with Ok, Cancel and Apply buttons
     */
    public JScribDialog(Shell parent)
	{
    	super(parent);
    	flag = JSCRIB_OK_BUTTON|JSCRIB_CANCEL_BUTTON|JSCRIB_APPLY_BUTTON;
    }
    
    /*
     * Constructs a Dialog with buttons given by the flag _flag
     */
	public JScribDialog(Shell parent, int _flag)
	{
		super(parent);
		flag = _flag;
	}
	
	protected void buttonPressed(int buttonId) 
	{
		switch (buttonId) 
		{
		case JSCRIB_OK_BUTTON :
		{
			okPressed();
			return;
		}
		case JSCRIB_CANCEL_BUTTON :
		{
			cancelPressed();
			return;
		}
		case JSCRIB_APPLY_BUTTON :
		{
			applyPressed();
			return;
		}
		case JSCRIB_HELP_BUTTON :
		{
			helpPressed();
			return;
		}
		}
	}
	
	protected void createButtonsForButtonBar(Composite parent) 
	{
		// create OK and Cancel buttons by default
		if ((flag & JSCRIB_OK_BUTTON)!=0)
		   createButton(parent,JSCRIB_OK_BUTTON,IDialogConstants.OK_LABEL,true);
		if ((flag & JSCRIB_CANCEL_BUTTON)!=0)
		   createButton(parent,JSCRIB_CANCEL_BUTTON,IDialogConstants.CANCEL_LABEL,false);
	    if ((flag & JSCRIB_APPLY_BUTTON)!=0)
		   createButton(parent,JSCRIB_APPLY_BUTTON,ReportCorePlugin.translate("APPLY"),false); //$NON-NLS-1$
	    if ((flag & JSCRIB_HELP_BUTTON)!=0)
	       createButton(parent,JSCRIB_HELP_BUTTON,ReportCorePlugin.translate("HELP"),false); //$NON-NLS-1$
	}
	
	/*
	 * Called when the button Ok is clicked
	 * Emits the signal applied and closes the dialog
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	protected void okPressed()
	{
		applied.emit();
		super.okPressed();
	}
	
	/*
	 * Called when the button Cancel is clicked
	 * Emits the signal canceled and closes the dialog
	 * @see org.eclipse.jface.dialogs.Dialog#cancelPressed()
	 */
	protected void cancelPressed()
	{
		canceled.emit();
		super.cancelPressed();
	}
	
	/*
	 * Called when the button Apply is clicked
	 * Emits the signal applied and stills the dialog open
	 */
	protected void applyPressed()
	{	
		applied.emit();
	}
	
	/*
	 * Called when the button help is clicked
	 * Do nothing
	 */
	protected void helpPressed()
	{	
	}
}
