/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StyleEditor.java,v 1.3 2008/05/23 14:12:16 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 17 dc. 2003
 *
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import java.util.List;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.report.ReportCorePlugin;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.SWTDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.SWTDStyle.SColor;
import org.eclipse.tptp.platform.report.drawutil.internal.SWTDStyle.SFont;
import org.eclipse.tptp.platform.report.drivers.ui.internal.SWTViewer;
import org.eclipse.tptp.platform.report.signals.internal.Signal;
import org.eclipse.tptp.platform.report.tools.internal.SimpleProgressMonitor;

/**
 * @author smoline
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class StyleEditor extends Composite {

	/**
	 * Get the multi selection help text.
	 */
	public static String getHelpMultiSelection()
	{
		return ReportCorePlugin.translate("TEXT_HELP_MULTISELECTION");
	}

	/**
	 * Internal font w_previewer implementation.
	 */
	public static class TextPreviewer {
		private SWTViewer f_text;
		private IDStyle f_style;
		private String f_string = null;
		DDocument doc = null;
		private DText f_dtxt = null;
		public TextPreviewer(String s, Composite parent) {
			this.f_string = s;
			this.f_text = new SWTViewer(parent, SWT.BORDER);
            this.f_text.setProgressMonitor(new SimpleProgressMonitor());
			this.f_text.setMargins(10,0,0,0);
			this.doc = new DDocument();
			DSection s1 = new DSection(""); //$NON-NLS-1$
			this.doc.addChild(s1);
			DParagraph p = new DParagraph(IDAlignment.CENTER);
			s1.addChild(p);
			this.f_dtxt = new DText(this.f_string);
			p.addChild(this.f_dtxt);
			this.f_text.setContent(this.doc);
		}

		public void refresh() {
		    this.f_text.refresh();
		}
		
		public Control getControl() {
			return this.f_text;
		}
		
		public void setDefaultStyle(IDStyle style) {
			this.f_style=style;
			IDFont dfont = this.f_style.getFont();
			if(dfont==null)
				dfont=new DFont();
			this.f_style.setFont(dfont);
			this.doc.setStyle(this.f_style);
			this.f_dtxt.setStyle(this.f_style);
			if(this.f_style.getBackColor()!=null)
				this.f_text.setBackground(SWTDStyle.getColor(Display.getCurrent(),this.f_style.getBackColor()).getColor());
			else
				this.f_text.setBackground(SWTDStyle.getDefaultBack(Display.getCurrent()));
			this.f_text.redraw();
		}

		public void setFont(FontData fontData) {
			IDFont dfont = this.f_style.getFont();
			int st = dfont.getStyle();
			if(fontData!=null){
				dfont.setFamily(fontData.getName());
				dfont.setSize(fontData.getHeight());
				if((fontData.getStyle() & SWT.NORMAL)!=0){
					st|=IDFont.NORMAL;
				}else{
					st&=~IDFont.NORMAL;
				}
				if((fontData.getStyle() & SWT.BOLD)!=0){
					st|=IDFont.BOLD;
				}else{
					st&=~IDFont.BOLD;
				}
				if((fontData.getStyle() & SWT.ITALIC)!=0){
					st|=IDFont.ITALIC;
				}else{
					st&=~IDFont.ITALIC;
				}
			}
			dfont.setStyle(st);
			this.f_style.setFont(dfont);
			this.f_text.redraw();
		}
		
		public void setForegroundColor(Color fcolor)
		{
			this.f_style.setForeColor(new DColor(fcolor.getRed(),fcolor.getGreen(),fcolor.getBlue()));
			this.f_text.redraw();
		}
		
		public void setBackgroundColor(Color bcolor)
		{
			this.f_style.setBackColor(new DColor(bcolor.getRed(),bcolor.getGreen(),bcolor.getBlue()));
			this.f_text.setBackground(SWTDStyle.getColor(Display.getCurrent(),this.f_style.getBackColor()).getColor());
			this.f_text.redraw();
		}
		
		public void setUnderline(boolean sel)
		{
			IDFont dfont = this.f_style.getFont();
			if(sel) {
				dfont.setStyle(dfont.getStyle()|IDFont.UNDERLINE);
			}else{
				dfont.setStyle(dfont.getStyle()&~IDFont.UNDERLINE);
			}
			this.f_style.setFont(dfont);
			this.f_text.redraw();
		}
		
		public void setStrikeOut(boolean sel)
		{
			IDFont dfont = this.f_style.getFont();
			if(sel) {
				dfont.setStyle(dfont.getStyle()|IDFont.STRIKE);
			}else{
				dfont.setStyle(dfont.getStyle()&~IDFont.STRIKE);
			}
			this.f_style.setFont(dfont);
			this.f_text.redraw();
		}

		public void setOverline(boolean sel)
		{
			IDFont dfont = this.f_style.getFont();
			if(sel) {
				dfont.setStyle(dfont.getStyle()|IDFont.OVERLINE);
			}else{
				dfont.setStyle(dfont.getStyle()&~IDFont.OVERLINE);
			}
			this.f_style.setFont(dfont);
			this.f_text.redraw();
		}

		public void setDashed(boolean sel)
		{
			IDFont dfont = this.f_style.getFont();
			if(sel) {
				dfont.setStyle(dfont.getStyle()|IDFont.DASHED);
			}else{
				dfont.setStyle(dfont.getStyle()&~IDFont.DASHED);
			}
			this.f_style.setFont(dfont);
			this.f_text.redraw();
		}
		
		public int getPreferredExtent() {
			return 40;
		}
	}
	class MyColorEditor {
		
		/** The extent. */
		private Point fExtent;
		/** The image for the push button. */
		Image fImage;
		/** The current RGB color value. */
		RGB fColorValue;
		/** The current color. */
		Color fColor;
		/** The image push button which open the color dialog. */
		Button fButton;
		/** Signal Emited. */
		public final Signal sgn_valueChanged = new Signal("valueChanged(org.eclipse.swt.graphics.Color)"); //$NON-NLS-1$
		
		/**
		 * Creates and returns a new color editor.
		 * 
		 * @param parent the parent composite of this color editor
		 */
		public MyColorEditor(Composite parent) {
			this.fButton= new Button(parent, SWT.PUSH);
			this.fExtent= computeImageSize(parent);
			this.fImage= new Image(parent.getDisplay(), this.fExtent.x, this.fExtent.y);
			
			GC gc= new GC(this.fImage);
			gc.setBackground(this.fButton.getBackground());
			gc.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
			gc.dispose();
			
			this.fButton.setImage(this.fImage);
			this.fButton.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent event) {
					ColorDialog colorDialog= new ColorDialog(MyColorEditor.this.fButton.getShell());
					colorDialog.setRGB(MyColorEditor.this.fColorValue);
					RGB newColor = colorDialog.open();
					if (newColor != null) {
						MyColorEditor.this.fColorValue= newColor;
						updateColorImage();
						MyColorEditor.this.sgn_valueChanged.emit(new Color(MyColorEditor.this.fButton.getDisplay(),newColor));
					}
				}
			});
			
			this.fButton.addDisposeListener(new DisposeListener() {
				public void widgetDisposed(DisposeEvent event) {
					if (MyColorEditor.this.fImage != null)  {
						MyColorEditor.this.fImage.dispose();
						MyColorEditor.this.fImage= null;
					}
					if (MyColorEditor.this.fColor != null) {
						MyColorEditor.this.fColor.dispose();
						MyColorEditor.this.fColor= null;
					}
				}
			});
		}
		
		/**
		 * Returns the current RGB color value.
		 * 
		 * @return an rgb with the current color value
		 */
		public RGB getColorValue() {
			return this.fColorValue;
		}
		
		/**
		 * Sets the current RGB color value.
		 * 
		 * @param rgb the new value for the rgb color value
		 */
		public void setColorValue(RGB rgb) {
			this.fColorValue= rgb;
			updateColorImage();
		}
		
		/**
		 * Returns the image push button.
		 * 
		 * @return the button which shows the current color as image
		 */
		public Button getButton() {
			return this.fButton;
		}
		
		/**
		 * Updates the color of the button image.
		 */
		protected void updateColorImage() {
			
			Display display= this.fButton.getDisplay();
			
			GC gc= new GC(this.fImage);
			gc.setForeground(display.getSystemColor(SWT.COLOR_BLACK));
			gc.drawRectangle(0, 2, this.fExtent.x - 1, this.fExtent.y - 4);
			
			if (this.fColor != null)
				this.fColor.dispose();
			
			this.fColor= new Color(display, this.fColorValue);
			gc.setBackground(this.fColor);
			gc.fillRectangle(1, 3, this.fExtent.x - 2, this.fExtent.y - 5);
			gc.dispose();
			
			this.fButton.setImage(this.fImage);
		}
		
		
		/**
		 * Computes the size for the image.
		 * 
		 * @param window the window on which to render the image
		 * @return the point with the image size
		 */
		protected Point computeImageSize(Control window) {
			GC gc= new GC(window);
			Font f= JFaceResources.getFontRegistry().get(JFaceResources.DEFAULT_FONT);
			gc.setFont(f);
			int height= gc.getFontMetrics().getHeight();
			gc.dispose();
			Point p= new Point(height * 3 - 6, height);
			return p;
		}
	}
	
	IDStyle d_fcurrentStyle=null;
	List d_fcurrentStylelist=null;
	
	Color altforeground = null;
	
	/** Signal Emited. 
	 * Emit true if have changes otherwise false.
	 */
	public final Signal styleChanged = new Signal("styleChanged()"); //$NON-NLS-1$
	
	/**
	 * @param parent
	 * @param style
	 */
	public StyleEditor(Composite parent, int style) {
		super(parent, style);
		altforeground = new Color(this.getDisplay(),200,200,200);
		createSWidget();
		styleChanged.connect(this, "applyStyle()");
	}

	/**
	 * Set the highlight color to the style differences.
	 * By default the color is RGB=(200,200,200)
	 * @param col the highlight color
	 */
	public void setMultiSelectionColor(Color col)
	{
		if(col==null || col.isDisposed())return;
		if(altforeground!=null){
			if(!altforeground.isDisposed()){
				altforeground.dispose();
			}
		}
		altforeground=col;
	}
	
	public void setStyle(org.eclipse.tptp.platform.report.core.internal.IDStyle style)
	{
		this.d_fcurrentStyle = style;
		this.d_fcurrentStylelist = null;
		this.d_selectedFont = null;
		initializeSWidget();
	}
	public void setStyleList(List stylelist)
	{
		this.d_fcurrentStyle = null;
		this.d_fcurrentStylelist = null;
		if(stylelist.size()>0){
			this.d_fcurrentStyle = (IDStyle)stylelist.get(0);
			if(stylelist.size()>0){
				this.d_fcurrentStylelist = stylelist;
			}
		}
		this.d_selectedFont = null;
		initializeSWidget();
	}

	boolean fontchanged=false;
	boolean bcolchanged=false;
	boolean fcolchanged=false;
	boolean undechanged=false;
	boolean strichanged=false;
	boolean overchanged=false;
	boolean dashchanged=false;
	
	public void applyStyle()
	{
		applyToStyle(this.d_fcurrentStyle);
		if(this.d_fcurrentStylelist!=null){
			for(int idx=0;idx<this.d_fcurrentStylelist.size();idx++){
				IDStyle style = (IDStyle)this.d_fcurrentStylelist.get(idx);
				
				applyToStyle(style);
			}
		}
//		fontchanged=false;
		bcolchanged=false;
		fcolchanged=false;
		undechanged=false;
		strichanged=false;
		overchanged=false;
		dashchanged=false;
		updateStateWidget();
	}
	
	public void applyToStyle(IDStyle style)
	{

		if(style==null)return;
		IDFont dfont = style.getFont();
		
		if (dfont==null)
			dfont = new DFont();
		int stold = dfont.getStyle();
		int st = 0;
		if(this.d_selectedFont!=null){
			dfont.setFamily(this.d_selectedFont.getName());
			dfont.setSize(this.d_selectedFont.getHeight());
			if((this.d_selectedFont.getStyle() & SWT.NORMAL)!=0){
				st=IDFont.NORMAL;
			}
			if((this.d_selectedFont.getStyle() & SWT.BOLD)!=0){
				st=IDFont.BOLD;
			}
			if((this.d_selectedFont.getStyle() & SWT.ITALIC)!=0){
				st+=IDFont.ITALIC;
			}
		}else{
			st=(~IDFont.UNDERLINE)&(~IDFont.STRIKE)&(~IDFont.OVERLINE)&(~IDFont.DASHED)&stold;
		}
		if(undechanged){
			if(this.w_underlineButton.getSelection())
				st|=IDFont.UNDERLINE;
		}else{
			st|=IDFont.UNDERLINE&stold;
		}
		if(strichanged){
			if(this.w_strikeoutButton.getSelection())
				st|=IDFont.STRIKE;
		}else{
			st|=IDFont.STRIKE&stold;
		}
		if(overchanged){
			if(this.w_overlineButton.getSelection())
				st|=IDFont.OVERLINE;
		}else{
			st|=IDFont.OVERLINE&stold;
		}
		if(dashchanged){
			if(this.w_dashedButton.getSelection())
				st|=IDFont.DASHED;
		}else{
			st|=IDFont.DASHED&stold;
		}
		dfont.setStyle(st);
		style.setFont(dfont);
		
		if(bcolchanged){
			if(this.w_backColorButton.getSelection()){
				IDColor bc = style.getBackColor();
				if(bc == null){
					bc = new DColor();
				}
				RGB rgbc = this.w_backColorEditor.getColorValue();
				bc.setRGB(rgbc.red,rgbc.green,rgbc.blue);
				style.setBackColor(bc);
			}else{
				style.setBackColor((IDColor)null);
			}
		}

		if(fcolchanged){
			if(this.w_foreColorButton.getSelection()){
				IDColor bc = style.getForeColor();
				if(bc == null){
					bc = new DColor();
				}
				RGB rgbc = this.w_foreColorEditor.getColorValue();
				bc.setRGB(rgbc.red,rgbc.green,rgbc.blue);
				style.setForeColor(bc);
			}else{
				style.setForeColor((IDColor)null);
			}
		}
		
	}
	
	protected void initializeSWidget()
	{
		if (d_fcurrentStyle == null) return;
		
		SFont sfont = SWTDStyle.getFont(getDisplay(),this.d_fcurrentStyle.getFont());
		if(sfont != null){
			FontData font = sfont.getFont().getFontData()[0];
			initFontWidget(font);
		}
		
		SColor backColor =null;
		Color bcolor=null;
		if(this.d_fcurrentStyle.getBackColor()==null){
			bcolor = SWTDStyle.getDefaultBack(getDisplay());
			this.w_backColorButton.setSelection(false);
			this.w_backColorButton2.setEnabled(false);
		}else{
			backColor = SWTDStyle.getColor(getDisplay(),this.d_fcurrentStyle.getBackColor());
			bcolor = backColor.getColor();
			this.w_backColorButton.setSelection(true);
			this.w_backColorButton2.setEnabled(true);
		}
		this.w_backColorEditor.setColorValue(bcolor.getRGB());
		
		SColor foreColor = SWTDStyle.getColor(getDisplay(),this.d_fcurrentStyle.getForeColor());
		if(this.d_fcurrentStyle.getForeColor()==null){
			this.w_foreColorButton.setSelection(false);
			this.w_foreColorButton2.setEnabled(false);
		}else{
			this.w_foreColorButton.setSelection(true);
			this.w_foreColorButton2.setEnabled(true);
		}
		this.w_foreColorEditor.setColorValue(foreColor.getColor().getRGB());
		
		int IDStyle = 0;
		if(this.d_fcurrentStyle.getFont() != null)
		{
			IDStyle = d_fcurrentStyle.getFont().getStyle();
		}
		
		w_underlineButton.setSelection((IDStyle & IDFont.UNDERLINE)!=0);
		w_strikeoutButton.setSelection((IDStyle & IDFont.STRIKE)!=0);
		w_overlineButton.setSelection((IDStyle & IDFont.OVERLINE)!=0);
		w_dashedButton.setSelection((IDStyle & IDFont.DASHED)!=0);

		DFont nfont = null;
		if(this.d_fcurrentStyle.getFont()!=null){
			nfont =new DFont();
			nfont.setFamily(this.d_fcurrentStyle.getFont().getFamily());
			nfont.setScript(this.d_fcurrentStyle.getFont().getScript());
			nfont.setSize(this.d_fcurrentStyle.getFont().getSize());
			nfont.setStyle(this.d_fcurrentStyle.getFont().getStyle());
		}
		this.w_previewer.setDefaultStyle(new DStyle(this.d_fcurrentStyle.getName(),
				nfont,this.d_fcurrentStyle.getForeColor(),this.d_fcurrentStyle.getBackColor()));
		this.w_previewer.refresh();
		updateStateWidget();
	}
	
	private Color defaultfontbackground = null;
	private Color defaultbackground = null;
	
	void updateStateWidget()
	{
		if(this.d_fcurrentStylelist!=null && haveDifferentFont()){
			this.w_fontLabel.setBackground(this.altforeground);
		}else{
			this.w_fontLabel.setBackground(defaultfontbackground);
		}
		if(this.d_fcurrentStylelist!=null && haveDifferentBCol()){
			this.w_backColorButton.setBackground(this.altforeground);
		}else{
			this.w_backColorButton.setBackground(defaultbackground);
		}
		if(this.d_fcurrentStylelist!=null && haveDifferentFCol()){
			this.w_foreColorButton.setBackground(this.altforeground);
		}else{
			this.w_foreColorButton.setBackground(defaultbackground);
		}
		if(this.d_fcurrentStylelist!=null && haveDifferentUnderline()){
			this.w_underlineButton.setBackground(this.altforeground);
		}else{
			this.w_underlineButton.setBackground(defaultbackground);
		}
		if(this.d_fcurrentStylelist!=null && haveDifferentStrikeOut()){
			this.w_strikeoutButton.setBackground(this.altforeground);
		}else{
			this.w_strikeoutButton.setBackground(defaultbackground);
		}
		if(this.d_fcurrentStylelist!=null && haveDifferentOverline()){
			this.w_overlineButton.setBackground(this.altforeground);
		}else{
			this.w_overlineButton.setBackground(defaultbackground);
		}
		if(this.d_fcurrentStylelist!=null && haveDifferentDashed()){
			this.w_dashedButton.setBackground(this.altforeground);
		}else{
			this.w_dashedButton.setBackground(defaultbackground);
		}
		
	}
	
	void initFontWidget(FontData fd)
	{
		int style = fd.getStyle();
		String strStyle = new String();
		if((style & SWT.NORMAL)!=0){
			strStyle = "Normal "; //$NON-NLS-1$
		}
		if((style & SWT.BOLD)!=0){
			strStyle += "Bold "; //$NON-NLS-1$
		}
		if((style & SWT.ITALIC)!=0){
			strStyle += "Italic "; //$NON-NLS-1$
		}
		
		this.w_fontLabel.setText(fd.getName()+", "+fd.getHeight()+" "+strStyle); //$NON-NLS-1$ //$NON-NLS-2$

	}
	private boolean haveDifferentFont(){
		if(this.d_fcurrentStylelist==null)return false;
		if(this.d_fcurrentStylelist.size()<2)return false;
		IDFont font = ((IDStyle)this.d_fcurrentStylelist.get(0)).getFont();
		boolean bold = (font!=null)?((font.getStyle()&IDFont.BOLD)==IDFont.BOLD):(false);
		boolean italic = (font!=null)?((font.getStyle()&IDFont.ITALIC)==IDFont.ITALIC):(false);
		for(int idx=1;idx<this.d_fcurrentStylelist.size();idx++){
			IDFont fonttmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getFont();
			if(font==null || font.getFamily()==null){
				if(fonttmp!=null){
					return true;
				}
				continue;
			}
			if(fonttmp==null || fonttmp.getFamily()==null)
				return true;
			if(!(font.getFamily().equalsIgnoreCase(fonttmp.getFamily()))
					|| (font.getSize()!=fonttmp.getSize())
					|| (((fonttmp.getStyle()&IDFont.BOLD)==IDFont.BOLD)!=bold)
					|| (((fonttmp.getStyle()&IDFont.ITALIC)==IDFont.ITALIC)!=italic)){
				return true;
			}
		}
		return false;
	}
	private boolean haveDifferentFCol(){
		if(this.d_fcurrentStylelist==null)return false;
		if(this.d_fcurrentStylelist.size()<2)return false;
		IDColor color = ((IDStyle)this.d_fcurrentStylelist.get(0)).getForeColor();
		for(int idx=1;idx<this.d_fcurrentStylelist.size();idx++){
			IDColor colortmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getForeColor();
			if(color==null){
				if(colortmp!=null){
					return true;
				}
				continue;
			}
			if(colortmp==null)
				return true;
			if((color.getBlue()!=colortmp.getBlue())
					||(color.getGreen()!=colortmp.getGreen())
					||(color.getRed()!=colortmp.getRed())){
				return true;
			}
		}
		return false;
	}
	private boolean haveDifferentBCol(){
		if(this.d_fcurrentStylelist==null)return false;
		if(this.d_fcurrentStylelist.size()<2)return false;
		IDColor color = ((IDStyle)this.d_fcurrentStylelist.get(0)).getBackColor();
		for(int idx=1;idx<this.d_fcurrentStylelist.size();idx++){
			IDColor colortmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getBackColor();
			if(color==null){
				if(colortmp!=null){
					return true;
				}
				continue;
			}
			if(colortmp==null)
				return true;
			if((color.getBlue()!=colortmp.getBlue())
					||(color.getGreen()!=colortmp.getGreen())
					||(color.getRed()!=colortmp.getRed())){
				return true;
			}
		}
		return false;
	}
	private boolean haveDifferentUnderline(){
		if(this.d_fcurrentStylelist==null)return false;
		if(this.d_fcurrentStylelist.size()<2)return false;
		IDFont font = ((IDStyle)this.d_fcurrentStylelist.get(0)).getFont();
		boolean underline = (font!=null)?((font.getStyle()&IDFont.UNDERLINE)==IDFont.UNDERLINE):(false);
		for(int idx=1;idx<this.d_fcurrentStylelist.size();idx++){
			IDFont fonttmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getFont();
			boolean underlinetmp = (fonttmp!=null)?((fonttmp.getStyle()&IDFont.UNDERLINE)==IDFont.UNDERLINE):(false);
			if(underline!=underlinetmp){
				return true;
			}
		}
		return false;
	}
	private boolean haveDifferentStrikeOut(){
		if(this.d_fcurrentStylelist==null)return false;
		if(this.d_fcurrentStylelist.size()<2)return false;
		IDFont font = ((IDStyle)this.d_fcurrentStylelist.get(0)).getFont();
		boolean strike = (font!=null)?((font.getStyle()&IDFont.STRIKE)==IDFont.STRIKE):(false);
		for(int idx=1;idx<this.d_fcurrentStylelist.size();idx++){
			IDFont fonttmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getFont();
			boolean striketmp = (fonttmp!=null)?((fonttmp.getStyle()&IDFont.STRIKE)==IDFont.STRIKE):(false);
			if(strike!=striketmp){
				return true;
			}
		}
		return false;
	}
	private boolean haveDifferentOverline(){
		if(this.d_fcurrentStylelist==null)return false;
		if(this.d_fcurrentStylelist.size()<2)return false;
		IDFont font = ((IDStyle)this.d_fcurrentStylelist.get(0)).getFont();
		boolean overline = (font!=null)?((font.getStyle()&IDFont.OVERLINE)==IDFont.OVERLINE):(false);
		for(int idx=1;idx<this.d_fcurrentStylelist.size();idx++){
			IDFont fonttmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getFont();
			boolean overlinetmp = (fonttmp!=null)?((fonttmp.getStyle()&IDFont.OVERLINE)==IDFont.OVERLINE):(false);
			if(overline!=overlinetmp){
				return true;
			}
		}
		return false;
	}
	private boolean haveDifferentDashed(){
		if(this.d_fcurrentStylelist==null)return false;
		if(this.d_fcurrentStylelist.size()<2)return false;
		IDFont font = ((IDStyle)this.d_fcurrentStylelist.get(0)).getFont();
		boolean dashed = (font!=null)?((font.getStyle()&IDFont.DASHED)==IDFont.DASHED):(false);
		for(int idx=1;idx<this.d_fcurrentStylelist.size();idx++){
			IDFont fonttmp = ((IDStyle)this.d_fcurrentStylelist.get(idx)).getFont();
			boolean dashedtmp = (fonttmp!=null)?((fonttmp.getStyle()&IDFont.DASHED)==IDFont.DASHED):(false);
			if(dashed!=dashedtmp){
				return true;
			}
		}
		return false;
	}

	private GridData createFill() {
		GridData gd= new GridData();
		gd.horizontalAlignment= GridData.FILL;
		gd.grabExcessHorizontalSpace= true;
		gd.verticalAlignment= GridData.FILL;
		gd.grabExcessVerticalSpace= true;
		return gd;
	}
	private GridData createHorizontalFill() {
		GridData gd= new GridData();
		gd.horizontalAlignment= GridData.FILL;
		gd.grabExcessHorizontalSpace= true;
		return gd;
	}
	
	Button w_changeFontButton = null;
	private Text w_fontLabel = null;
	protected Button w_foreColorButton = null;
	protected Button w_foreColorButton2 = null;
	private MyColorEditor w_foreColorEditor = null;
	protected Button w_backColorButton = null;
	protected Button w_backColorButton2 = null;
	private MyColorEditor w_backColorEditor = null;
	Button w_underlineButton = null;
	Button w_strikeoutButton = null;
	Button w_overlineButton = null;
	Button w_dashedButton = null;
	TextPreviewer w_previewer =null;
	FontData d_selectedFont = null;
	protected void createSWidget()
	{
		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 10;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		setLayout(layout);
		setLayoutData(createFill());
		
		Group gb = new Group( this, SWT.NONE);
	    layout = new GridLayout();
	    layout.numColumns = 3;
	    gb.setLayout(layout);
	    gb.setLayoutData(createHorizontalFill());
		gb.setText(ReportCorePlugin.translate("TEXT_FONT")); //$NON-NLS-1$
		this.w_fontLabel = new Text(gb,SWT.READ_ONLY | SWT.BORDER);
	    data = createHorizontalFill();
		data.horizontalSpan = 3;
		this.w_fontLabel.setLayoutData(data);
		this.w_fontLabel.setText(ReportCorePlugin.translate("UNKNOWN")); //$NON-NLS-1$
		this.defaultfontbackground=this.w_fontLabel.getBackground();
		this.w_changeFontButton = new Button(gb, SWT.PUSH);
		this.w_changeFontButton.setText(ReportCorePlugin.translate("CHANGE_TEXT_FONT")); //$NON-NLS-1$
		this.w_changeFontButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				FontDialog fontDialog =
					new FontDialog(StyleEditor.this.w_changeFontButton.getShell());
				if(StyleEditor.this.d_selectedFont!=null){
					FontData fdloc[]= new FontData[1];
					fdloc[0]=StyleEditor.this.d_selectedFont;
					fontDialog.setFontList(fdloc);
				}else{
					if(StyleEditor.this.d_fcurrentStyle!=null){
						SFont sfont = SWTDStyle.getFont(getDisplay(),StyleEditor.this.d_fcurrentStyle.getFont());
						if(sfont != null){
							fontDialog.setFontList(sfont.getFont().getFontData());
						}
					}
				}
				StyleEditor.this.d_selectedFont = fontDialog.open();
				if (StyleEditor.this.d_selectedFont != null) {
					initFontWidget(StyleEditor.this.d_selectedFont);
					StyleEditor.this.w_previewer.setFont(StyleEditor.this.d_selectedFont);
				}
				StyleEditor.this.styleChanged.emit();
			}
		});
		this.w_changeFontButton.addDisposeListener(new DisposeListener() {
			public void widgetDisposed(DisposeEvent event) {
				StyleEditor.this.w_changeFontButton = null;
			}
		});
		gb = new Group( this, SWT.NONE);
		GridLayout glayout= new GridLayout(2,false); 
		gb.setLayout( glayout );
	    gb.setLayoutData(createHorizontalFill());
		gb.setText(ReportCorePlugin.translate("FONT_COLORS")); //$NON-NLS-1$

		//Label l= new Label(gb, SWT.LEFT);
		this.w_foreColorButton= new Button(gb, SWT.LEFT|SWT.CHECK);
		this.w_foreColorButton.setText(ReportCorePlugin.translate("FOREGROUND_COLOR"));  //$NON-NLS-1$
		GridData gd= new GridData();
		gd.horizontalAlignment= GridData.BEGINNING;
		this.w_foreColorButton.setLayoutData(gd);
		
		this.w_foreColorEditor= new MyColorEditor(gb);
		this.w_foreColorButton2= this.w_foreColorEditor.getButton();
		gd= new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalAlignment= GridData.BEGINNING;
		this.w_foreColorButton2.setLayoutData(gd);
		this.w_foreColorButton2.setEnabled(false);
		this.w_foreColorEditor.setColorValue(new RGB(0,0,0));
		
		this.w_foreColorButton.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent arg0) {
				fcolchanged=true;
				w_foreColorButton2.setEnabled(w_foreColorButton.getSelection());
				StyleEditor.this.styleChanged.emit();
			}
		});
		this.w_foreColorButton2.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent arg0) {
				fcolchanged=true;
				StyleEditor.this.styleChanged.emit();
			}
		});
		
		this.w_backColorButton= new Button(gb, SWT.LEFT|SWT.CHECK);
		this.w_backColorButton.setText(ReportCorePlugin.translate("BACKGROUND_COLOR"));  //$NON-NLS-1$
		gd= new GridData();
		gd.horizontalAlignment= GridData.BEGINNING;
		this.w_backColorButton.setLayoutData(gd);
		
		this.w_backColorEditor= new MyColorEditor(gb);
		this.w_backColorButton2= this.w_backColorEditor.getButton();
		gd= new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalAlignment= GridData.BEGINNING;
		this.w_backColorButton2.setLayoutData(gd);
		this.w_backColorButton2.setEnabled(false);
		this.w_backColorEditor.setColorValue(new RGB(255,255,255));

		this.w_backColorButton.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent arg0) {
				bcolchanged=true;
				w_backColorButton2.setEnabled(w_backColorButton.getSelection());
				StyleEditor.this.styleChanged.emit();
			}
		});
		this.w_backColorButton2.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent arg0) {
				bcolchanged=true;
				StyleEditor.this.styleChanged.emit();
			}
		});
		
		gb = new Group( this, SWT.NONE);
		glayout= new GridLayout(2,true); 
		gb.setLayout( glayout );
	    gb.setLayoutData(createHorizontalFill());
		gb.setText(ReportCorePlugin.translate("FONT_ATTRIBUTES")); //$NON-NLS-1$
		this.w_underlineButton = new Button(gb,SWT.CHECK);
		this.w_underlineButton.setText(ReportCorePlugin.translate("UNDERLINE")); //$NON-NLS-1$
		this.w_underlineButton.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				undechanged=true;
				StyleEditor.this.w_previewer.setUnderline(StyleEditor.this.w_underlineButton.getSelection());
				StyleEditor.this.styleChanged.emit();
			}
		});
		this.defaultbackground=this.w_underlineButton.getBackground();
		this.w_strikeoutButton = new Button(gb,SWT.CHECK);
		this.w_strikeoutButton.setText(ReportCorePlugin.translate("STRIKE_OUT")); //$NON-NLS-1$
		this.w_strikeoutButton.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				strichanged=true;
				StyleEditor.this.w_previewer.setStrikeOut(StyleEditor.this.w_strikeoutButton.getSelection());
				StyleEditor.this.styleChanged.emit();
			}
		});
		this.w_overlineButton = new Button(gb,SWT.CHECK);
		this.w_overlineButton.setText(ReportCorePlugin.translate("OVERLINE")); //$NON-NLS-1$
		this.w_overlineButton.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				overchanged=true;
				StyleEditor.this.w_previewer.setOverline(StyleEditor.this.w_overlineButton.getSelection());
				StyleEditor.this.styleChanged.emit();
			}
		});
		this.w_dashedButton = new Button(gb,SWT.CHECK);
		this.w_dashedButton.setText(ReportCorePlugin.translate("DASHED")); //$NON-NLS-1$
		this.w_dashedButton.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				dashchanged=true;
				StyleEditor.this.w_previewer.setDashed(StyleEditor.this.w_dashedButton.getSelection());
				StyleEditor.this.styleChanged.emit();
			}
		});

		this.w_previewer = new TextPreviewer(ReportCorePlugin.translate("TEXT_FOR_PREVIEW"), this); //$NON-NLS-1$
		gd = new GridData(GridData.FILL_BOTH);
		gd.heightHint = this.w_previewer.getPreferredExtent();
		gd.widthHint = this.w_previewer.getPreferredExtent();
		this.w_previewer.getControl().setLayoutData(gd);

		this.w_foreColorEditor.sgn_valueChanged.connect(this.w_previewer,"setForegroundColor(org.eclipse.swt.graphics.Color)"); //$NON-NLS-1$
		this.w_backColorEditor.sgn_valueChanged.connect(this.w_previewer,"setBackgroundColor(org.eclipse.swt.graphics.Color)"); //$NON-NLS-1$
	}

}
