/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StyleRegistryEditor.java,v 1.3 2008/05/23 14:12:16 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 5 janv. 2004
 *
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;
import org.eclipse.tptp.platform.report.ReportCorePlugin;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlWriter;
import org.eclipse.tptp.platform.report.drivers.xml.internal.XSDXmlParserAdapter;
import org.eclipse.tptp.platform.report.signals.internal.Signal;
import org.eclipse.xsd.util.XSDParser;

/**
 * @author smoline
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class StyleRegistryEditor extends Composite {

	Signal itemSelected = new Signal("itemSelected(org.eclipse.tptp.platform.report.core.internal.IDStyle)"); //$NON-NLS-1$
	Signal itemsSelected = new Signal("itemsSelected(sellist)"); //$NON-NLS-1$
	DStyleRegistry localRegistry = null;
	DStyleRegistry sourceRegistry = null;
	public Signal valueChanged = new Signal("valueChanged(boolean)"); //$NON-NLS-1$
	/**
	 * @param parent
	 * @param style
	 */
	public StyleRegistryEditor(Composite parent, int style) {
		super(parent, style);
		createSWidget();
	}
	List thelist = null;
	private StyleEditor theeditor = null;
	protected void createSWidget()
	{
		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 2;
		layout.horizontalSpacing = 10;
		setLayout(layout);
		
		this.thelist = new List(this,SWT.MULTI|SWT.BORDER|SWT.H_SCROLL|SWT.V_SCROLL);
		data= new GridData();
		data.horizontalAlignment= GridData.FILL;
		data.grabExcessHorizontalSpace= true;
		data.verticalAlignment = GridData.FILL;
		this.thelist.setLayoutData(data);
		
		this.theeditor = new StyleEditor(this,SWT.NONE);
		
		this.thelist.addSelectionListener( new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
		        int selcount = StyleRegistryEditor.this.thelist.getSelectionCount();
		        if(selcount==0)
		        	return;
		        if(selcount==1){
					String sel = StyleRegistryEditor.this.thelist.getItem(StyleRegistryEditor.this.thelist.getSelectionIndex());
			        IDStyle sty = StyleRegistryEditor.this.localRegistry.getFirstStyle(sel);
			        StyleRegistryEditor.this.itemSelected.emit((DStyle)sty);
			        return;
		        }
		        String[] seltab = StyleRegistryEditor.this.thelist.getSelection();
		        ArrayList sellist = new ArrayList(seltab.length);
		        for(int idx=0;idx<seltab.length;idx++){
		        	IDStyle sty = StyleRegistryEditor.this.localRegistry.getFirstStyle(seltab[idx]);
		        	if(sty!=null){
		        		sellist.add(sty);
		        	}
		        }
		        StyleRegistryEditor.this.itemsSelected.emit(sellist);
			}
		});
		this.itemSelected.connect(this.theeditor,"setStyle(org.eclipse.tptp.platform.report.core.internal.IDStyle)"); //$NON-NLS-1$
		this.itemsSelected.connect(this.theeditor,"setStyleList(java.util.List)"); //$NON-NLS-1$
	}
	
	public void applyUpdate()
	{	
		Iterator i = localRegistry.iterator();
		while (i.hasNext())
		{
			IDStyle so = (IDStyle)i.next();
			IDStyle s = sourceRegistry.getFirstStyle(so.getName());	
			
			s.setBackColor(so.getBackColor());
			s.setForeColor(so.getForeColor());
			s.setFont(so.getFont());
			s.setNumberingFormat(so.getNumberingFormat());
			s.setWallpaper(so.getWallpaper());
			s.setName(so.getName());
		}
	}
	
	protected void updateSWidget()
	{
		this.thelist.removeAll();
		if (localRegistry == null) return;
		
		Iterator iter = localRegistry.iterator();
		while(iter.hasNext()){
			Object obj = iter.next();
			if((obj != null)&&(obj instanceof IDStyle)){
				DStyle style = (DStyle)obj;
				thelist.add(style.getName());
			}
		}
		if (thelist.getItemCount()>0)
		{	
		   thelist.select(0);
		   String first = thelist.getItem(0);
		   IDStyle sty = localRegistry.getFirstStyle(first);
		   theeditor.setStyle((DStyle)sty);
		}
	}
	
	public void setStyleRegistry(DStyleRegistry registry)
	{
		localRegistry = new DStyleRegistry(); 
		sourceRegistry = registry;
		
		Iterator i = registry.iterator();
		while (i.hasNext())
		{
			DStyle s = new DStyle();
			IDStyle so = (IDStyle)i.next();
			
			IDColor cl = null;
			if (so.getBackColor()!=null)
			{
				cl=new DColor(so.getBackColor().getRed(), 
						      so.getBackColor().getGreen(),
							  so.getBackColor().getBlue());
			}
			s.setBackColor(cl);
			
			cl = null;
			if (so.getForeColor()!=null)
			{
				cl=new DColor(so.getForeColor().getRed(), 
						      so.getForeColor().getGreen(),
							  so.getForeColor().getBlue());
			}
			s.setForeColor(cl);
			
			IDFont f = null;
			if (so.getFont()!=null)
			{
				f = new DFont(so.getFont().getFamily(), so.getFont().getScript(),
						so.getFont().getSize(), so.getFont().getStyle());
			}
			s.setFont(f);
			
			s.setNumberingFormat(so.getNumberingFormat());
			s.setWallpaper(so.getWallpaper());
			s.setName(so.getName());
			
			localRegistry.putStyle(s);
		}
		
		updateSWidget();
	}

	public void updateStyleRegistry(DStyleRegistry newregistry)
	{
		Iterator i = newregistry.iterator();
		while (i.hasNext())
		{
			Object s = i.next();
			if (s instanceof IDStyle){
				java.util.List sol = this.localRegistry.getStyles(((IDStyle)s).getName());
				if((sol != null)&&(sol.size()>0)){
					Iterator j = sol.iterator();
					while (j.hasNext())
					{
						Object so = j.next();
						if (so instanceof IDStyle){
							((IDStyle)so).setBackColor(((IDStyle)s).getBackColor());
							((IDStyle)so).setForeColor(((IDStyle)s).getForeColor());
							((IDStyle)so).setFont(((IDStyle)s).getFont());
							((IDStyle)so).setNumberingFormat(((IDStyle)s).getNumberingFormat());
							((IDStyle)so).setWallpaper(((IDStyle)s).getWallpaper());
						}
					}
				}else{
					this.localRegistry.putStyle((IDStyle)s);
				}
			}
		}
		updateSWidget();
	}
	
	public void fromText(String txt)
	{
		if((txt==null)||(txt==ReportCorePlugin.translate("3")))return; //$NON-NLS-1$
		DXmlReader reader = new DXmlReader(new XSDXmlParserAdapter(new XSDParser()));
		ByteArrayInputStream buf = new ByteArrayInputStream(txt.getBytes());
		try{
			reader.read( buf );
			DStyleRegistry newregistry = reader.getStyleRegistry();
			if(newregistry != null)
				updateStyleRegistry(newregistry);
		}
		catch(Exception e)
		{
			System.err.println(ReportCorePlugin.translate("READ_FAILED"));   //$NON-NLS-1$
			e.printStackTrace();     
		}
	}
	
	public String toText()
	{
        DXmlWriter aw = new DXmlWriter();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try{
          aw.write(buf,this.localRegistry);
        }catch(Exception e){
        }
		return buf.toString();
	}

}
