/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StylesFieldEditor.java,v 1.2 2008/05/23 14:12:16 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 12 janv. 2004
 *
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.signals.internal.Signal;

/**
 * @author smoline
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class StylesFieldEditor extends FieldEditor {
	
	private DStyleRegistry d_registry = null;
	private StyleRegistryEditor w_stylesField = null;

	public Signal valueChanged = new Signal("valueChanged(boolean)");
	
	/**
	 * 
	 */
	public StylesFieldEditor() {
		super();
	}

	/**
	 * @param name
	 * @param labelText
	 * @param parent
	 */
	public StylesFieldEditor(String name, String labelText, Composite parent) {
		init(name, labelText);
		createControl(parent);
		connectSignals();
	}
	
	private void connectSignals()
	{
		if(this.w_stylesField == null)return;
		this.w_stylesField.valueChanged.connect(this.valueChanged);
	}
	
	public void setStylesRegistry(DStyleRegistry reg)
	{
		this.d_registry = reg;
		if(this.w_stylesField != null){
			this.w_stylesField.setStyleRegistry(this.d_registry);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditor#adjustForNumColumns(int)
	 */
	protected void adjustForNumColumns(int numColumns) {
		GridData gd = (GridData)this.w_stylesField.getLayoutData();
		gd.horizontalSpan = numColumns - 1;
		gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditor#doFillIntoGrid(org.eclipse.swt.widgets.Composite, int)
	 */
	protected void doFillIntoGrid(Composite parent, int numColumns) {
		this.w_stylesField = new StyleRegistryEditor(parent,SWT.NONE);
		if(this.d_registry != null)this.w_stylesField.setStyleRegistry(this.d_registry);
		GridData gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.grabExcessHorizontalSpace = true;
		gd.verticalAlignment = GridData.FILL;
		gd.grabExcessVerticalSpace = true;
		gd.widthHint = 400;
		this.w_stylesField.setLayoutData(gd);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditor#doLoad()
	 */
	protected void doLoad() {
		if (this.w_stylesField != null) {
			String value = getPreferenceStore().getString(getPreferenceName());
			this.w_stylesField.fromText(value);
//			oldValue = value;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditor#doLoadDefault()
	 */
	protected void doLoadDefault() {
		if (this.w_stylesField != null) {
			String value = getPreferenceStore().getDefaultString(getPreferenceName());
			this.w_stylesField.fromText(value);
		}
//		valueChanged();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditor#doStore()
	 */
	protected void doStore() {
		this.w_stylesField.applyUpdate();
		getPreferenceStore().setValue(getPreferenceName(), this.w_stylesField.toText());
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditor#getNumberOfControls()
	 */
	public int getNumberOfControls() {
		return 1;
	}

}
