/* ***********************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ToolTipRedrawer.java,v 1.2 2008/05/23 14:12:16 jcayne Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 ************************************************************/


/*
 * Created on 28 oct. 2004
 */
package org.eclipse.tptp.platform.report.ui.swt.widgets.internal;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.ACC;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/**
 * @author kdarcour
 * @deprecated As of TPTP 4.5.0, use the TPTP Business Intelligence and Reporting Tools (BIRT) reporting infrastructure (<code>org.eclipse.tptp.platform.report.birt</code>).
 *
 * This class is used to reproduce the same tooltip behavior on Windows and Linux
 * when the mouse move over graphics or images
 */
public class ToolTipRedrawer implements PaintListener {
	/**
	 * Parent control where the tooltip have to be drawn
	 */
	protected Control parentControl = null;
	/**
	 * Tooltip shell
	 */
	protected Shell toolTipShell = null;
	/**
	 * Tooltip text
	 */
	protected String toolTipText = null;
	
	/**
	 * Create a new tooltip for the given parent control
	 * @param _parent the parent control
	 */
	public ToolTipRedrawer(Control _parent) {
		parentControl = _parent;
		toolTipShell = new Shell(parentControl.getShell(),SWT.ON_TOP|SWT.NO_FOCUS);
		toolTipShell.setLayout(new RowLayout());
		toolTipShell.setBackground(Display.getDefault().getSystemColor(SWT.COLOR_INFO_BACKGROUND));
		toolTipShell.addPaintListener(this);
		toolTipShell.setSize(10,10);
		toolTipShell.getAccessible().addAccessibleControlListener( new AccessibleControlAdapter() {
			public void getRole(AccessibleControlEvent e) {
				e.detail = ACC.ROLE_TOOLTIP;
			}
			public void getValue(AccessibleControlEvent e) {
				e.result = toolTipText;
			}
			public void getState(AccessibleControlEvent e){
				e.detail = ACC.STATE_FOCUSED;
			}
		});
	}
	
	/**
	 * Display the tooltip using the given text
	 * The tooltip will stay on screen until it is told otherwise
	 * @param value the toolTipText to display
	 */
	public void showToolTip(String text) {
		if (( text == null ) || ( text.equalsIgnoreCase("")) ) { //$NON-NLS-1$
			toolTipShell.setVisible(false);
			return;
		}
		// used for a tooltip update
		boolean repaint = false;
		if (toolTipShell.getVisible() && !text.equals(toolTipText)) {
			repaint = true;
		}
		toolTipText = text;
		
		int w = toolTipShell.getBounds().width;
		Point xy = Display.getDefault().getCursorLocation();
		int h_cursor = 32;
		for ( int i = 0; i < Display.getDefault().getCursorSizes().length;i++ ) {
			if ( Display.getDefault().getCursorSizes()[i].y < h_cursor )
				h_cursor = Display.getDefault().getCursorSizes()[i].y;
		}	
		if ( xy.x + w > Display.getDefault().getBounds().width ) {
			int tempX = ( xy.x + w ) - Display.getDefault().getBounds().width;
			if ( tempX > Display.getDefault().getBounds().width )
				xy.x = 0;
			xy.x = xy.x - tempX;
		}
		toolTipShell.setLocation(xy.x, xy.y + h_cursor);
		// used for a tooltip update
		if (repaint) {
			toolTipShell.setVisible(false);
		}
		toolTipShell.setVisible(true);
		toolTipShell.getAccessible().setFocus(parentControl.handle);
	}
	
	
	/**
	 * Hide the tooltip
	 */
	public void hideToolTip() {
		toolTipShell.setVisible(false);
	}
	
	/**
	 * Draw the tooltip text on the control widget when a paint event is received
	 */
	public void paintControl(PaintEvent event) {
		Point xy = event.gc.textExtent(toolTipText);		
		event.gc.drawText(toolTipText,2,0,true);	
		toolTipShell.setSize( xy.x + 6, xy.y + 2);
	}
}
