/********************************************************************** 
 * Copyright (c) 2005, 2006  IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ContextSelectionMenuListener.java,v 1.5 2006/01/27 20:47:40 ewchan Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.trace.views.internal.view.columnlabels.ContextUpdaterHelper;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;

public class ContextSelectionMenuListener implements IMenuListener  {

	private EObject mofObject;
	private IContextViewer viewer;
	
	public void setViewer(IContextViewer viewer_)
	{
		viewer = viewer_;	
	}
	
	public void setMOFObject(EObject mofObject_)
	{
		mofObject = mofObject_;
	}

	protected void addActionToMenu(IMenuManager parent, Action action) {
		ActionContributionItem item= new ActionContributionItem(action);
		parent.add(item);
	}
	
	public void menuAboutToShow(IMenuManager manager) {
		manager.removeAll();

		String[] contexts = ContextUpdaterHelper.getContexts(mofObject);
		String selectedContext = ContextUpdaterHelper.getCurrentContext(contexts, viewer);
		viewer.setSelectedContext(selectedContext);
		
		for (int i= 0; i < contexts.length; i++) {
			
			if(ContextManager.getContextLanguage(contexts[i]) == null)
				continue; //no context specified for this language 
			
			ContextSetAction action = new ContextSetAction(contexts[i], viewer);
			
			if (selectedContext != null && selectedContext.equals(contexts[i]))
				action.setChecked(true);
			else
				action.setChecked(false);
			
			addActionToMenu(manager, action);
		}
	}	
}
