/********************************************************************** 
 * Copyright (c) 2005, 2006  IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: ContextSetAction.java,v 1.4 2006/01/27 20:47:40 ewchan Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.hyades.trace.views.adapter.internal.IContextViewer;
import org.eclipse.hyades.ui.provisional.context.ContextManager;
import org.eclipse.hyades.ui.provisional.context.IContextLanguage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
;

public class ContextSetAction extends Action {
	
	private String context;
	private IContextLanguage language;
	private IContextViewer viewer;
	
	public ContextSetAction(String context_, IContextViewer viewer_)
	{
		context = context_;
		viewer = viewer_;
		
		language = ContextManager.getContextLanguage(context);
		setImageDescriptor(language.icon());
		setText(language.name());
		setToolTipText(language.description());
	}
	
	public void run() {
		viewer.setSelectedContext(context);
	}
	
	public void run(IAction action) {
		run();
	}
}
