/********************************************************************** 
 * Copyright (c) 2005, 2007  IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: FilterOutAction.java,v 1.4 2007/01/23 17:45:17 ewchan Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import java.util.*;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.*;
import org.eclipse.hyades.models.hierarchy.extensions.*;
import org.eclipse.hyades.models.trace.*;
import org.eclipse.hyades.models.trace.impl.TracePackageImpl;
import org.eclipse.hyades.trace.ui.FilterTraceViewer;
import org.eclipse.hyades.trace.views.adapter.internal.*;
import org.eclipse.hyades.ui.filters.IFilterAttribute;
import org.eclipse.hyades.ui.filters.internal.dialogs.FiltersAdvancedUI;
import org.eclipse.hyades.ui.internal.filters.BasicFeatureFilterAttribute;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

/**
 * This class is used for the 'Filter Out' action available from the context menu.
 */
public class FilterOutAction  implements IViewActionDelegate {

	private ArrayList filterOutObjs = new ArrayList(2);	
//	private EObject filterOutObjs[];	
	private FilterTraceViewer viewer;
	//private static RelationalOperators FILTER_OUT_OPERATOR = RelationalOperators.get(RelationalOperators.NEQ);
	private static String FILTER_OUT_OPERATOR = BasicFeatureFilterAttribute.getOperatorString(RelationalOperators.get(RelationalOperators.NEQ));	
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		if (viewer == null)
			return;
		
		ProfilingAdvancedTabAttributeSet advancedSet = new ProfilingAdvancedTabAttributeSet();
		
		SimpleSearchQuery query = viewer.advancedQuery();
		EList arguments;
		LogicalExpression logicalExpression;	
		int openIndex = -1;
		
		if (query != null && query.getWhereExpression() != null 
				&& (query.getWhereExpression() instanceof LogicalExpression))
		{
			logicalExpression = (LogicalExpression)query.getWhereExpression();			
			logicalExpression.setOperator(LogicalOperators.AND_LITERAL);  /* Navid Mehregani - bugzilla 163095: The group expression should be 'AND' */
			arguments = logicalExpression.getArguments();
		}
		else if (query != null && query.getWhereExpression() == null)
		{
			logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
			logicalExpression.setOperator(LogicalOperators.AND_LITERAL);  /* Navid Mehregani - bugzilla 163095: The group expression should be 'AND' */
			arguments = logicalExpression.getArguments();
			query.setWhereExpression(logicalExpression);
		}
		else
		{
			return;
		}		
		
		openIndex = openIndex + arguments.size();
		
		for (int i = 0; i < filterOutObjs.size(); i++)
		{
			EAttribute attribute = null;
			String value = null;
			Object obj = filterOutObjs.get(i);
			if (obj instanceof TRCPackage)
			{
				attribute = TracePackageImpl.init().getTRCPackage_Name();
				value = ((TRCPackage)obj).getName();
			}
			else if (obj instanceof TRCClass)
			{
				attribute = TracePackageImpl.init().getTRCClass_Name();
				value = ((TRCClass)obj).getName();
			}
			else if ((obj instanceof TRCMethod) && !(viewer instanceof MemoryStatisticViewer))
			{
				attribute = TracePackageImpl.init().getTRCMethod_Name();
				value = ((TRCMethod)obj).getName();
			}

			if (attribute != null && value != null)
			{
				IFilterAttribute filterAttribute = advancedSet.getFilterAttribute(attribute);
				
				if (filterAttribute != null)
				{
					WhereExpression whereExpression = filterAttribute.getWhereExpression(FILTER_OUT_OPERATOR, value);
					whereExpression.setName(FiltersAdvancedUI.getWhereExpressionName(logicalExpression, filterAttribute));
					arguments.add(whereExpression);
				}
					
			}
			openIndex++;
		}
		
		viewer.updateAdvancedQuery(query, openIndex);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {

		filterOutObjs.clear();
		if (selection != null && selection instanceof IStructuredSelection)
		{
			Iterator iter = ((IStructuredSelection)selection).iterator();
		
			while (iter.hasNext())
			{
				Object obj = iter.next();
				
				if (obj instanceof TRCPackage || obj instanceof TRCClass || obj instanceof TRCMethod)
					filterOutObjs.add(obj);
			}
						
		}
	}

	public void init(IViewPart view)
	{
		if (view instanceof FilterTraceViewer)
			viewer = (FilterTraceViewer) view;
		else
			viewer = null;
	}

	public void dispose()
	{
		filterOutObjs = null;
		viewer = null;
	}
	
}
